/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence.quality;

import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.core.sequence.quality.QualityAggregator;

public class MaximalQualityAggregator
implements QualityAggregator {
    final byte[] data;

    public MaximalQualityAggregator(int size) {
        this.data = new byte[size];
    }

    @Override
    public synchronized void aggregate(SequenceQuality quality) {
        if (quality.size() != this.data.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < quality.size(); ++i) {
            this.data[i] = (byte)Math.max(this.data[i], quality.value(i));
        }
    }

    @Override
    public SequenceQuality getQuality() {
        return new SequenceQuality(this.data);
    }
}

