/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence.quality;

import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.core.sequence.quality.QualityAggregator;
import java.util.Arrays;

public final class MinimalQualityAggregator
implements QualityAggregator {
    final byte[] data;

    public MinimalQualityAggregator(int size) {
        this.data = new byte[size];
        Arrays.fill(this.data, (byte)127);
    }

    @Override
    public synchronized void aggregate(SequenceQuality quality) {
        if (quality.size() != this.data.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < quality.size(); ++i) {
            this.data[i] = (byte)Math.min(this.data[i], quality.value(i));
        }
    }

    @Override
    public SequenceQuality getQuality() {
        return new SequenceQuality(this.data);
    }
}

