/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence.quality;

import com.milaboratory.core.sequence.quality.AverageQualityAggregator;
import com.milaboratory.core.sequence.quality.MaximalQualityAggregator;
import com.milaboratory.core.sequence.quality.MiniMaxQualityAggregator;
import com.milaboratory.core.sequence.quality.MinimalQualityAggregator;
import com.milaboratory.core.sequence.quality.QualityAggregator;
import com.milaboratory.core.sequence.quality.SumQualityAggregator;

public enum QualityAggregationType {
    Min(new AF(){

        @Override
        public QualityAggregator get(int size) {
            return new MinimalQualityAggregator(size);
        }
    }),
    Max(new AF(){

        @Override
        public QualityAggregator get(int size) {
            return new MaximalQualityAggregator(size);
        }
    }),
    Sum(new AF(){

        @Override
        public QualityAggregator get(int size) {
            return new SumQualityAggregator(size, 50);
        }
    }),
    Average(new AF(){

        @Override
        public QualityAggregator get(int size) {
            return new AverageQualityAggregator(size);
        }
    }),
    MiniMax(new AF(){

        @Override
        public QualityAggregator get(int size) {
            return new MiniMaxQualityAggregator(size);
        }
    });

    private final AF factory;

    private QualityAggregationType(AF factory) {
        this.factory = factory;
    }

    public QualityAggregator create(int size) {
        return this.factory.get(size);
    }

    private static interface AF {
        public QualityAggregator get(int var1);
    }
}

