/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.tree;

import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.tree.MutationGuide;
import com.milaboratory.core.tree.SequenceTreeMap;

final class BranchingEnumerator<S extends Sequence<S>, O> {
    final S reference;
    final MutationGuide guide;
    byte mode;
    boolean autoMove1;
    byte code;
    int position;
    SequenceTreeMap.Node<O> node;

    BranchingEnumerator(S reference, MutationGuide guide) {
        this.reference = reference;
        this.guide = guide;
    }

    public void setup(byte mode, boolean autoMove1) {
        this.mode = mode;
        this.autoMove1 = autoMove1;
        this.node = null;
    }

    public void reset(int position, SequenceTreeMap.Node<O> node) {
        this.position = position;
        this.node = node;
        this.code = (byte)-1;
        if (this.autoMove1) {
            this.move1();
        }
        this.checkIterationEnd();
    }

    private void move1() {
        if (this.node == null) {
            return;
        }
        if (this.position >= this.reference.size()) {
            this.node = null;
            return;
        }
        this.node = this.node.links[((Sequence)this.reference).codeAt(this.position++)];
    }

    public void checkIterationEnd() {
        switch (this.mode) {
            case 0: {
                if (this.position >= this.reference.size()) {
                    this.node = null;
                }
                return;
            }
            case 1: {
                if (this.position >= this.reference.size() - 1 && this.code != -1) {
                    this.node = null;
                }
                return;
            }
            case 2: {
                if (this.position >= this.reference.size() + 1) {
                    this.node = null;
                }
                return;
            }
        }
        throw new IllegalStateException();
    }

    public SequenceTreeMap.Node<O> next() {
        if (this.node == null) {
            return null;
        }
        switch (this.mode) {
            case 0: {
                do {
                    this.code = (byte)(this.code + 1);
                    if (this.code != ((Sequence)this.reference).getAlphabet().size()) continue;
                    if (this.position >= this.reference.size() - 1) {
                        this.node = null;
                        return null;
                    }
                    this.code = 0;
                    this.node = this.node.links[((Sequence)this.reference).codeAt(this.position++)];
                    if (this.node != null) continue;
                    return null;
                } while (this.code == ((Sequence)this.reference).codeAt(this.position) || this.node.links[this.code] == null || this.guide != null && !this.guide.allowMutation(this.reference, this.position, (byte)0, this.code));
                return this.node.links[this.code];
            }
            case 1: {
                do {
                    if (this.position >= this.reference.size() - 1 && this.code != -1 || this.position >= this.reference.size()) {
                        this.node = null;
                        return null;
                    }
                    if (this.code != -1) {
                        this.node = this.node.links[((Sequence)this.reference).codeAt(this.position++)];
                    } else {
                        this.code = 0;
                    }
                    if (this.guide != null && !this.guide.allowMutation(this.reference, this.position, (byte)1, (byte)-1)) continue;
                    return this.node;
                } while (this.node != null);
            }
            case 2: {
                do {
                    this.code = (byte)(this.code + 1);
                    if (this.code == ((Sequence)this.reference).getAlphabet().size()) {
                        if (this.position >= this.reference.size()) {
                            this.node = null;
                            return null;
                        }
                        this.code = 0;
                        this.node = this.node.links[((Sequence)this.reference).codeAt(this.position++)];
                    }
                    if (this.node != null) continue;
                    return null;
                } while (this.node.links[this.code] == null || this.guide != null && !this.guide.allowMutation(this.reference, this.position, (byte)2, this.code));
                return this.node.links[this.code];
            }
        }
        return null;
    }

    public int getNextPositionAfterBranching() {
        switch (this.mode) {
            case 0: {
                return this.position + 1;
            }
            case 1: {
                return this.position + 1;
            }
            case 2: {
                return this.position;
            }
        }
        return -1;
    }

    public int getPosition() {
        return this.position;
    }
}

