/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.tree;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.LinearGapAlignmentScoring;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.tree.BranchingEnumerator;
import com.milaboratory.core.tree.MutationGuide;
import com.milaboratory.core.tree.SequenceTreeMap;
import com.milaboratory.core.tree.TreeSearchParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class NeighborhoodIterator<S extends Sequence<S>, O> {
    final S reference;
    final TreeSearchParameters parameters;
    final byte[][] branchingSequences;
    final MutationGuide guide;
    int branchingSequenceIndex = 0;
    int lastEnumerator;
    SequenceTreeMap.Node<O> root;
    BranchingEnumerator<S, O>[] branchingEnumerators = new BranchingEnumerator[1];

    public NeighborhoodIterator(S reference, TreeSearchParameters parameters, MutationGuide guide, SequenceTreeMap.Node<O> root) {
        this.parameters = parameters;
        this.guide = guide;
        this.reference = reference;
        this.root = root;
        this.branchingSequences = parameters.getDifferencesCombination();
        this.branchingEnumerators[0] = new BranchingEnumerator(reference, guide);
        this.setupBranchingEnumerators();
    }

    private void ensureCapacity(int newSize) {
        int oldSize = this.branchingEnumerators.length;
        if (oldSize < newSize) {
            this.branchingEnumerators = Arrays.copyOfRange(this.branchingEnumerators, 0, newSize);
            for (int i = oldSize; i < newSize; ++i) {
                this.branchingEnumerators[i] = new BranchingEnumerator(this.reference, this.guide);
            }
        }
    }

    private void setupBranchingEnumerators() {
        byte[] bSequence = this.branchingSequences[this.branchingSequenceIndex];
        this.ensureCapacity(bSequence.length);
        int previous = -1;
        for (int i = 0; i < bSequence.length; ++i) {
            boolean autoMove1;
            byte current = bSequence[i];
            boolean bl = autoMove1 = previous == 1 && current == 2;
            if (this.parameters.isGreedy()) {
                autoMove1 = autoMove1 || previous == 2 && current == 1 || previous == 2 && current == 0;
            }
            this.branchingEnumerators[i].setup(current, autoMove1);
            previous = bSequence[i];
        }
        this.branchingEnumerators[0].reset(0, this.root);
        this.lastEnumerator = bSequence.length - 1;
    }

    public O next() {
        SequenceTreeMap.Node<O> n = this.nextNode();
        return n == null ? null : (O)n.object;
    }

    public SequenceTreeMap.Node<O> nextNode() {
        if (this.branchingSequenceIndex == this.branchingSequences.length) {
            return null;
        }
        while (true) {
            SequenceTreeMap.Node<O> n;
            if (this.lastEnumerator == -1) {
                --this.lastEnumerator;
                n = this.traverseToTheEnd(this.root, 0);
                if (n != null && n.object != null) {
                    return n;
                }
            }
            int i = this.lastEnumerator;
            block1: while (i >= 0) {
                while (i < this.lastEnumerator) {
                    n = this.branchingEnumerators[i].next();
                    if (n == null) {
                        --i;
                        continue block1;
                    }
                    this.branchingEnumerators[i + 1].reset(this.branchingEnumerators[i].getNextPositionAfterBranching(), n);
                    ++i;
                }
                assert (i == this.lastEnumerator);
                n = this.branchingEnumerators[i].next();
                if (n != null) {
                    if ((n = this.traverseToTheEnd(n, this.branchingEnumerators[i].getNextPositionAfterBranching())) == null || n.object == null) continue;
                    return n;
                }
                --i;
            }
            if (++this.branchingSequenceIndex >= this.branchingSequences.length || this.getPenalty() > this.parameters.getMaxPenalty()) {
                this.branchingSequenceIndex = this.branchingSequences.length;
                return null;
            }
            this.setupBranchingEnumerators();
        }
    }

    public SequenceTreeMap.Node<O> traverseToTheEnd(SequenceTreeMap.Node<O> node, int position) {
        while (position < this.reference.size() && (node = node.links[((Sequence)this.reference).codeAt(position++)]) != null) {
        }
        return node;
    }

    public byte[] getCurrentBranchingSequence() {
        return this.branchingSequences[this.branchingSequenceIndex];
    }

    public int getMutationsCount() {
        return this.branchingSequences[this.branchingSequenceIndex].length;
    }

    public byte getType(int i) {
        return this.branchingSequences[this.branchingSequenceIndex][i];
    }

    public Mutations<S> getCurrentMutations() {
        if (this.lastEnumerator < 0) {
            return new Mutations(((Sequence)this.reference).getAlphabet(), new int[0]);
        }
        MutationsBuilder<byte> builder = new MutationsBuilder(((Sequence)this.reference).getAlphabet()).ensureCapacity(this.lastEnumerator + 1);
        block5: for (int i = 0; i <= this.lastEnumerator; ++i) {
            BranchingEnumerator<S, O> currentBE = this.branchingEnumerators[i];
            int position = currentBE.getPosition();
            switch (this.getCurrentBranchingSequence()[i]) {
                case 0: {
                    builder.appendSubstitution(position, ((Sequence)this.reference).codeAt(position), currentBE.code);
                    continue block5;
                }
                case 1: {
                    builder.appendDeletion(position, ((Sequence)this.reference).codeAt(position));
                    continue block5;
                }
                case 2: {
                    builder.appendInsertion(position, currentBE.code);
                    continue block5;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        return builder.createAndDestroy();
    }

    public Alignment<S> getCurrentAlignment() {
        Mutations<S> currentMutations = this.getCurrentMutations();
        return new Alignment<S>(this.reference, currentMutations, new Range(0, this.reference.size()), new Range(0, this.reference.size() + currentMutations.getLengthDelta()), (float)((double)this.reference.size() + this.getPenalty()));
    }

    public Alignment<S> getCurrentAlignment(LinearGapAlignmentScoring<S> scoring) {
        Mutations<S> currentMutations = this.getCurrentMutations();
        return new Alignment<S>(this.reference, currentMutations, new Range(0, this.reference.size()), new Range(0, this.reference.size() + currentMutations.getLengthDelta()), scoring);
    }

    public int getPosition(int i) {
        return this.branchingEnumerators[i].getPosition();
    }

    public byte getCode(int i) {
        return this.branchingEnumerators[i].code;
    }

    public int getMismatches() {
        int ret = 0;
        for (byte b : this.getCurrentBranchingSequence()) {
            if (b != 0) continue;
            ++ret;
        }
        return ret;
    }

    public int getDeletions() {
        int ret = 0;
        for (byte b : this.getCurrentBranchingSequence()) {
            if (b != 1) continue;
            ++ret;
        }
        return ret;
    }

    public int getInsertions() {
        int ret = 0;
        for (byte b : this.getCurrentBranchingSequence()) {
            if (b != 2) continue;
            ++ret;
        }
        return ret;
    }

    public int[] getIntroducedDifferences() {
        int[] ret = new int[3];
        byte[] arr$ = this.getCurrentBranchingSequence();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte b;
            byte by = b = arr$[i$];
            ret[by] = ret[by] + 1;
        }
        return ret;
    }

    public double getPenalty() {
        double p = 0.0;
        byte[] bSequence = this.branchingSequences[this.branchingSequenceIndex];
        for (int i = bSequence.length - 1; i >= 0; --i) {
            p += this.parameters.getPenalty(bSequence[i]);
        }
        return p;
    }

    public Iterable<O> it() {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new NeighbourhoodIteratorWrapper(NeighborhoodIterator.this);
            }
        };
    }

    public List<O> toList() {
        ArrayList<O> list = new ArrayList<O>();
        for (O o : this.it()) {
            list.add(o);
        }
        return list;
    }

    private static final class NeighbourhoodIteratorWrapper<O, S extends Sequence<S>>
    implements Iterator<O> {
        final NeighborhoodIterator<S, O> iterator;
        O next;

        private NeighbourhoodIteratorWrapper(NeighborhoodIterator<S, O> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            this.next = this.iterator.next();
            return this.next != null;
        }

        @Override
        public O next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

