/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class PenaltyUtils {
    public static byte[][] getDifferencesCombination(double max, double[] penalty) {
        return PenaltyUtils.getDifferencesCombination(max, penalty, null);
    }

    public static byte[][] getDifferencesCombination(double max, final double[] penalty, int[] maxErrors) {
        int i;
        byte[] count = new byte[3];
        ArrayList<SequenceWrapper> sequences = new ArrayList<SequenceWrapper>();
        sequences.add(new SequenceWrapper());
        int from = 0;
        int to = 1;
        do {
            for (i = from; i < to; ++i) {
                SequenceWrapper wrapper = (SequenceWrapper)sequences.get(i);
                for (byte j = 0; j < 3; j = (byte)(j + 1)) {
                    if (!(wrapper.penaltyValue + penalty[j] <= max) || maxErrors != null && wrapper.getErrorsOfType(j) >= maxErrors[j]) continue;
                    sequences.add(wrapper.next(j, penalty[j]));
                }
            }
        } while ((from = to) != (to = sequences.size()));
        Comparator<SequenceWrapper> wrapperComparator = new Comparator<SequenceWrapper>(){

            @Override
            public int compare(SequenceWrapper o1, SequenceWrapper o2) {
                int i;
                int v = Double.compare(o1.penaltyValue, o2.penaltyValue);
                if (v != 0) {
                    return v;
                }
                v = Double.compare(o1.sequence.length, o2.sequence.length);
                if (v != 0) {
                    return v;
                }
                for (i = 0; i < o1.sequence.length; ++i) {
                    v = Double.compare(penalty[o1.sequence[i]], penalty[o2.sequence[i]]);
                    if (v == 0) continue;
                    return v;
                }
                for (i = 0; i < o1.sequence.length; ++i) {
                    v = Byte.compare(o1.sequence[i], o2.sequence[i]);
                    if (v == 0) continue;
                    return v;
                }
                return 0;
            }
        };
        Collections.sort(sequences, wrapperComparator);
        byte[][] result = new byte[sequences.size()][];
        for (i = sequences.size() - 1; i >= 0; --i) {
            result[i] = ((SequenceWrapper)sequences.get((int)i)).sequence;
        }
        return result;
    }

    private static final class SequenceWrapper {
        final byte[] sequence;
        final double penaltyValue;

        SequenceWrapper() {
            this.penaltyValue = 0.0;
            this.sequence = new byte[0];
        }

        private SequenceWrapper(byte[] sequence, double penaltyValue) {
            this.sequence = sequence;
            this.penaltyValue = penaltyValue;
        }

        public SequenceWrapper next(byte type, double penalty) {
            byte[] newSequence = Arrays.copyOfRange(this.sequence, 0, this.sequence.length + 1);
            newSequence[this.sequence.length] = type;
            return new SequenceWrapper(newSequence, this.penaltyValue + penalty);
        }

        public int getErrorsOfType(byte type) {
            int counter = 0;
            for (byte e : this.sequence) {
                if (type != e) continue;
                ++counter;
            }
            return counter;
        }
    }
}

