/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.tree;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.core.tree.MutationGuide;
import com.milaboratory.core.tree.NeighborhoodIterator;
import com.milaboratory.core.tree.TreeSearchParameters;
import com.milaboratory.util.Factory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SequenceTreeMap<S extends Sequence<S>, O>
implements Serializable {
    public final Alphabet<S> alphabet;
    public final Node<O> root;

    public SequenceTreeMap(Alphabet<S> alphabet) {
        this.alphabet = alphabet;
        this.root = new Node(alphabet.size());
    }

    public O createIfAbsent(S sequence, Factory<O> factory) {
        int size = sequence.size();
        Node<O> node = this.root;
        for (int i = 0; i < size; ++i) {
            node = node.getOrCreate(((Sequence)sequence).codeAt(i));
        }
        if (node.object == null) {
            node.object = factory.create();
        }
        return node.object;
    }

    public O put(S sequence, O object) {
        int size = sequence.size();
        Node<O> node = this.root;
        for (int i = 0; i < size; ++i) {
            node = node.getOrCreate(((Sequence)sequence).codeAt(i));
        }
        Object prev = node.object;
        node.object = object;
        return prev;
    }

    public Node<O> getNode(S sequence) {
        int size = sequence.size();
        Node<O> node = this.root;
        for (int i = 0; i < size && (node = node.links[((Sequence)sequence).codeAt(i)]) != null; ++i) {
        }
        return node;
    }

    public O get(S sequence) {
        Node<O> node = this.getNode(sequence);
        if (node == null) {
            return null;
        }
        return node.object;
    }

    public O remove(S sequence) {
        int i;
        int size = sequence.size();
        Node node = this.root;
        Node[] nodes = new Node[size + 1];
        nodes[0] = this.root;
        for (i = 0; i < size && (node = node.links[((Sequence)sequence).codeAt(i)]) != null; ++i) {
            nodes[i + 1] = node;
        }
        if (node == null) {
            return null;
        }
        Object ret = node.object;
        node.object = null;
        block1: for (i = size; i > 0 && node.object == null; --i) {
            for (int j = this.alphabet.size() - 1; j >= 0; --j) {
                if (node.links[j] != null) break block1;
            }
            node = nodes[i - 1];
            node.links[((Sequence)sequence).codeAt((int)(i - 1))] = null;
        }
        return ret;
    }

    public Map<S, O> toMap() {
        Object n;
        HashMap map = new HashMap();
        ValuesOp op = this.valuesOp();
        while ((n = op.take()) != null) {
            map.put(op.getSequence(), n);
        }
        return map;
    }

    public NodeOp nodesOp() {
        return new NodeOp(this.root);
    }

    public ValuesOp valuesOp() {
        return new ValuesOp(this.root);
    }

    public NodeIterator nodeIterator() {
        return new NodeIterator(this.root);
    }

    public Iterable<O> values() {
        return CUtils.it((OutputPort)this.valuesOp());
    }

    public Iterable<Node<O>> nodes() {
        return new Iterable<Node<O>>(){

            @Override
            public Iterator<Node<O>> iterator() {
                return new NodeIterator(SequenceTreeMap.this.root);
            }
        };
    }

    public NeighborhoodIterator<S, O> getNeighborhoodIterator(S reference, int mismatches, int deletions, int insertions, int totalErrors) {
        return this.getNeighborhoodIterator(reference, new TreeSearchParameters(mismatches, deletions, insertions, totalErrors));
    }

    public NeighborhoodIterator<S, O> getNeighborhoodIterator(S reference, int mismatches, int deletions, int insertions, int totalErrors, MutationGuide<S> guide) {
        return this.getNeighborhoodIterator(reference, new TreeSearchParameters(mismatches, deletions, insertions, totalErrors), guide);
    }

    public NeighborhoodIterator<S, O> getNeighborhoodIterator(S reference, int mismatches, int deletions, int insertions) {
        return this.getNeighborhoodIterator(reference, new TreeSearchParameters(mismatches, deletions, insertions));
    }

    public NeighborhoodIterator<S, O> getNeighborhoodIterator(S reference, double maxPenalty, double[] penalties, int[] maxErrors, MutationGuide<S> guide) {
        return this.getNeighborhoodIterator(reference, new TreeSearchParameters(maxErrors, penalties, maxPenalty), guide);
    }

    public NeighborhoodIterator<S, O> getNeighborhoodIterator(S reference, TreeSearchParameters parameters) {
        return this.getNeighborhoodIterator(reference, parameters, null);
    }

    public NeighborhoodIterator<S, O> getNeighborhoodIterator(S reference, TreeSearchParameters parameters, MutationGuide<S> guide) {
        return new NeighborhoodIterator<S, O>(reference, parameters, guide, this.root);
    }

    private static final class NodeWrapper<O>
    implements Serializable {
        private byte position = (byte)-1;
        private Node<O> node;

        NodeWrapper() {
        }

        NodeWrapper(Node<O> node) {
            this.node = node;
        }

        void reset(Node<O> node) {
            this.node = node;
            this.position = (byte)-1;
        }

        Node<O> getNext() {
            while ((this.position = (byte)(this.position + 1)) < this.node.links.length) {
                if (this.node.links[this.position] == null) continue;
                return this.node.links[this.position];
            }
            return null;
        }
    }

    public final class ValuesOp
    implements OutputPort<O>,
    Serializable {
        final NodeOp nodeOp;

        public ValuesOp(Node<O> root) {
            this.nodeOp = new NodeOp(root);
        }

        public O take() {
            Object n = this.nodeOp.take();
            return n == null ? null : (Object)((Node)n).object;
        }

        public S getSequence() {
            return this.nodeOp.getSequence();
        }
    }

    public final class NodeIterator
    extends CUtils.OPIterator<Node<O>>
    implements Serializable {
        public NodeIterator(Node<O> root) {
            super((OutputPort)new NodeOp(root));
        }

        public Node<O> next() {
            return (Node)super.next();
        }

        public S getSequence() {
            return ((NodeOp)this.op).getSequence();
        }
    }

    public final class NodeOp
    implements OutputPort<Node<O>>,
    Serializable {
        int pointer = 0;
        NodeWrapper<O>[] wrappers = new NodeWrapper[10];

        public NodeOp(Node<O> root) {
            this.wrappers[0] = new NodeWrapper(root);
        }

        private void ensureNext() {
            if (this.pointer + 1 == this.wrappers.length) {
                this.wrappers = Arrays.copyOf(this.wrappers, this.wrappers.length * 3 / 2 + 1);
            }
            if (this.wrappers[this.pointer + 1] == null) {
                this.wrappers[this.pointer + 1] = new NodeWrapper();
            }
        }

        public Node<O> take() {
            if (this.pointer == -1) {
                return null;
            }
            do {
                NodeWrapper nodeWrapper;
                Node node;
                if ((node = (nodeWrapper = this.wrappers[this.pointer]).getNext()) != null) {
                    this.ensureNext();
                    this.wrappers[++this.pointer].reset(node);
                    if (node.object == null) continue;
                    return node;
                }
                --this.pointer;
            } while (this.pointer >= 0);
            return null;
        }

        public S getSequence() {
            SequenceBuilder<byte> builder = SequenceTreeMap.this.alphabet.createBuilder().ensureCapacity(this.pointer);
            for (int i = 0; i < this.pointer; ++i) {
                builder.append(this.wrappers[i].position);
            }
            return builder.createAndDestroy();
        }
    }

    public static final class Node<O>
    implements Serializable {
        final Node<O>[] links;
        O object;

        public Node(int letters) {
            this.links = new Node[letters];
        }

        public Node<O> getOrCreate(byte code) {
            Node<O> node = this.links[code];
            if (node == null) {
                node = this.links[code] = new Node<O>(this.links.length);
            }
            return node;
        }

        public O getObject() {
            return this.object;
        }

        public void setObject(O object) {
            this.object = object;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

