/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.tree;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.TextNode;
import com.milaboratory.core.tree.PenaltyUtils;
import com.milaboratory.primitivio.annotations.Serializable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
@Serializable(asJson=true)
public final class TreeSearchParameters
implements java.io.Serializable {
    public static final double[] DEFAULT_PENALTY = new double[]{0.1, 0.21, 0.32};
    private static final double UNIFORM_PENALTY_VALUE = 1.0;
    private static final double[] UNIFORM_PENALTY = new double[]{1.0, 1.0, 1.0};
    public static final TreeSearchParameters ONE_MISMATCH = new TreeSearchParameters(1, 0, 0, 1);
    public static final TreeSearchParameters ONE_INDEL = new TreeSearchParameters(0, 1, 1, 1);
    public static final TreeSearchParameters ONE_MISMATCH_OR_INDEL = new TreeSearchParameters(1, 1, 1, 1);
    public static final TreeSearchParameters TWO_MISMATCHES = new TreeSearchParameters(2, 0, 0, 2);
    public static final TreeSearchParameters TWO_INDELS = new TreeSearchParameters(0, 2, 2, 2);
    public static final TreeSearchParameters TWO_MISMATCHES_OR_INDELS = new TreeSearchParameters(2, 2, 2, 2);
    public static final TreeSearchParameters THREE_MISMATCHES = new TreeSearchParameters(3, 0, 0, 3);
    public static final TreeSearchParameters THREE_INDELS = new TreeSearchParameters(0, 3, 3, 3);
    public static final TreeSearchParameters THREE_MISMATCHES_OR_INDELS = new TreeSearchParameters(3, 3, 3, 3);
    public static final TreeSearchParameters FOUR_MISMATCHES = new TreeSearchParameters(4, 0, 0, 4);
    public static final TreeSearchParameters FOUR_INDELS = new TreeSearchParameters(0, 4, 4, 4);
    public static final TreeSearchParameters FOUR_MISMATCHES_OR_INDELS = new TreeSearchParameters(4, 4, 4, 4);
    private final int[] maxErrors;
    private final double[] penalty;
    private final double maxPenalty;
    private final byte[][] differencesCombination;
    private final boolean greedy;
    private static final HashMap<String, TreeSearchParameters> parametersByName = new HashMap();
    private static final HashMap<TreeSearchParameters, String> nameByParameters = new HashMap();

    public TreeSearchParameters(int[] maxErrors, double[] penalty, double maxPenalty) {
        this(maxErrors, penalty, maxPenalty, true);
    }

    public TreeSearchParameters(int[] maxErrors, double[] penalty, double maxPenalty, boolean greedy) {
        if (penalty.length != 3 || maxErrors.length != 3) {
            throw new IllegalArgumentException();
        }
        this.maxErrors = (int[])maxErrors.clone();
        this.penalty = (double[])penalty.clone();
        this.maxPenalty = maxPenalty;
        this.greedy = greedy;
        this.differencesCombination = PenaltyUtils.getDifferencesCombination(maxPenalty, penalty, maxErrors);
    }

    public TreeSearchParameters(int mismatches, int deletions, int insertions) {
        this(mismatches, deletions, insertions, true);
    }

    public TreeSearchParameters(int mismatches, int deletions, int insertions, boolean greedy) {
        this(new int[]{mismatches, deletions, insertions}, DEFAULT_PENALTY, TreeSearchParameters.maxPenaltyFor(mismatches, deletions, insertions), greedy);
    }

    public TreeSearchParameters(int mismatches, int deletions, int insertions, int totalMutations, boolean greedy) {
        this(new int[]{mismatches, deletions, insertions}, UNIFORM_PENALTY, 1.0 * (double)totalMutations, greedy);
    }

    public TreeSearchParameters(int mismatches, int deletions, int insertions, int totalMutations) {
        this(mismatches, deletions, insertions, totalMutations, true);
    }

    public TreeSearchParameters(int maxSubstitutions, int maxDeletions, int maxInsertions, double substitutionPenalty, double deletionPenalty, double insertionPenalty, double maxPenalty, boolean greedy) {
        this.maxErrors = new int[]{maxSubstitutions, maxDeletions, maxInsertions};
        this.penalty = new double[]{substitutionPenalty, deletionPenalty, insertionPenalty};
        this.maxPenalty = maxPenalty;
        this.differencesCombination = PenaltyUtils.getDifferencesCombination(maxPenalty, this.penalty, this.maxErrors);
        this.greedy = greedy;
    }

    public TreeSearchParameters(int maxSubstitutions, int maxDeletions, int maxInsertions, double substitutionPenalty, double deletionPenalty, double insertionPenalty, double maxPenalty) {
        this(maxSubstitutions, maxDeletions, maxInsertions, substitutionPenalty, deletionPenalty, insertionPenalty, maxPenalty, true);
    }

    private static double maxPenaltyFor(int mismatches, int deletions, int insertions) {
        double maxPenalty = 0.1;
        maxPenalty += (double)mismatches * DEFAULT_PENALTY[0];
        maxPenalty += (double)deletions * DEFAULT_PENALTY[1];
        return maxPenalty += (double)insertions * DEFAULT_PENALTY[2];
    }

    public int getMaxErrors(int errorType) {
        return this.maxErrors[errorType];
    }

    public double getPenalty(int errorType) {
        return this.penalty[errorType];
    }

    public int getMaxSubstitutions() {
        return this.maxErrors[0];
    }

    public int getMaxDeletions() {
        return this.maxErrors[1];
    }

    public int getMaxInsertions() {
        return this.maxErrors[2];
    }

    public double getSubstitutionPenalty() {
        return this.penalty[0];
    }

    public double getDeletionPenalty() {
        return this.penalty[1];
    }

    public double getInsertionPenalty() {
        return this.penalty[2];
    }

    public double getMaxPenalty() {
        return this.maxPenalty;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    byte[][] getDifferencesCombination() {
        return this.differencesCombination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TreeSearchParameters)) {
            return false;
        }
        TreeSearchParameters that = (TreeSearchParameters)o;
        if (Double.compare(that.maxPenalty, this.maxPenalty) != 0) {
            return false;
        }
        if (this.greedy != that.greedy) {
            return false;
        }
        if (!Arrays.equals(this.maxErrors, that.maxErrors)) {
            return false;
        }
        return Arrays.equals(this.penalty, that.penalty);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.maxErrors);
        result = 31 * result + Arrays.hashCode(this.penalty);
        long temp = Double.doubleToLongBits(this.maxPenalty);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.greedy ? 1 : 0);
        return result;
    }

    private static void addKnown(String name, TreeSearchParameters params) {
        parametersByName.put(name.toLowerCase(), params);
        nameByParameters.put(params, name);
    }

    static {
        TreeSearchParameters.addKnown("oneMismatch", ONE_MISMATCH);
        TreeSearchParameters.addKnown("oneIndel", ONE_INDEL);
        TreeSearchParameters.addKnown("oneMismatchOrIndel", ONE_MISMATCH_OR_INDEL);
        TreeSearchParameters.addKnown("twoMismatches", TWO_MISMATCHES);
        TreeSearchParameters.addKnown("twoIndels", TWO_INDELS);
        TreeSearchParameters.addKnown("twoMismatchesOrIndels", TWO_MISMATCHES_OR_INDELS);
        TreeSearchParameters.addKnown("threeMismatches", THREE_MISMATCHES);
        TreeSearchParameters.addKnown("threeIndels", THREE_INDELS);
        TreeSearchParameters.addKnown("threeMismatchesOrIndels", THREE_MISMATCHES_OR_INDELS);
        TreeSearchParameters.addKnown("fourMismatches", FOUR_MISMATCHES);
        TreeSearchParameters.addKnown("fourIndels", FOUR_INDELS);
        TreeSearchParameters.addKnown("fourMismatchesOrIndels", FOUR_MISMATCHES_OR_INDELS);
    }

    public static final class Serializer
    extends JsonSerializer<TreeSearchParameters> {
        public void serialize(TreeSearchParameters value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String knownName = (String)nameByParameters.get(value);
            if (knownName != null) {
                jgen.writeString(knownName);
            } else {
                jgen.writeStartObject();
                jgen.writeObjectField("greedy", (Object)value.greedy);
                if (value.maxErrors[0] != 0) {
                    jgen.writeObjectField("maxSubstitutions", (Object)value.maxErrors[0]);
                }
                if (value.maxErrors[1] != 0) {
                    jgen.writeObjectField("maxDeletions", (Object)value.maxErrors[1]);
                }
                if (value.maxErrors[2] != 0) {
                    jgen.writeObjectField("maxInsertions", (Object)value.maxErrors[2]);
                }
                if (Arrays.equals(value.penalty, UNIFORM_PENALTY)) {
                    jgen.writeObjectField("totalMutations", (Object)((int)value.maxPenalty));
                } else if (!Arrays.equals(value.penalty, DEFAULT_PENALTY)) {
                    jgen.writeObjectField("substitutionPenalty", (Object)value.penalty[0]);
                    jgen.writeObjectField("deletionPenalty", (Object)value.penalty[1]);
                    jgen.writeObjectField("insertionPenalty", (Object)value.penalty[2]);
                    jgen.writeObjectField("maxPenalty", (Object)value.maxPenalty);
                }
                jgen.writeEndObject();
            }
        }
    }

    public static final class Deserializer
    extends JsonDeserializer<TreeSearchParameters> {
        public TreeSearchParameters deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode maxPenaltyNode;
            JsonNode node = (JsonNode)jp.readValueAsTree();
            if (node instanceof TextNode) {
                TreeSearchParameters params = (TreeSearchParameters)parametersByName.get(node.textValue().toLowerCase());
                if (params == null) {
                    throw new IllegalArgumentException("Unknown parameter set: " + node.textValue());
                }
                return params;
            }
            boolean greedy = true;
            JsonNode tmp = node.get("greedy");
            if (tmp != null) {
                greedy = tmp.asBoolean();
            }
            int[] maxErrors = new int[3];
            tmp = node.get("maxSubstitutions");
            if (tmp != null) {
                maxErrors[0] = tmp.asInt();
            }
            if ((tmp = node.get("maxDeletions")) != null) {
                maxErrors[1] = tmp.asInt();
            }
            if ((tmp = node.get("maxInsertions")) != null) {
                maxErrors[2] = tmp.asInt();
            }
            if ((maxPenaltyNode = node.get("maxPenalty")) == null) {
                JsonNode totalMutationsNode = node.get("totalMutations");
                if (totalMutationsNode == null) {
                    if (node.get("substitutionPenalty") != null || node.get("deletionPenalty") != null || node.get("insertionPenalty") != null) {
                        throw new IllegalArgumentException("Cannot set totalErrors and penalty related field simultaneously.");
                    }
                    return new TreeSearchParameters(maxErrors[0], maxErrors[1], maxErrors[2]);
                }
                if (node.get("substitutionPenalty") != null || node.get("deletionPenalty") != null || node.get("insertionPenalty") != null) {
                    throw new IllegalArgumentException("maxPenaltyNode is absent.");
                }
                return new TreeSearchParameters(maxErrors[0], maxErrors[1], maxErrors[2], totalMutationsNode.asInt());
            }
            double maxPenalty = maxPenaltyNode.asDouble();
            double[] penalty = new double[3];
            tmp = node.get("substitutionPenalty");
            if (tmp != null) {
                penalty[0] = tmp.asDouble();
            } else if (maxErrors[0] != 0) {
                throw new IllegalArgumentException("substitutionPenalty is absent.");
            }
            tmp = node.get("deletionPenalty");
            if (tmp != null) {
                penalty[1] = tmp.asDouble();
            } else if (maxErrors[1] != 0) {
                throw new IllegalArgumentException("deletionPenalty is absent.");
            }
            tmp = node.get("insertionPenalty");
            if (tmp != null) {
                penalty[2] = tmp.asDouble();
            } else if (maxErrors[2] != 0) {
                throw new IllegalArgumentException("insertionPenalty is absent.");
            }
            return new TreeSearchParameters(maxErrors, penalty, maxPenalty, greedy);
        }
    }
}

