/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.primitivio;

import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.primitivio.PrimitivO;
import com.milaboratory.primitivio.Serializer;
import com.milaboratory.primitivio.Util;
import gnu.trove.map.hash.TByteObjectHashMap;
import java.util.HashMap;

public final class CustomSerializerImpl
implements Serializer {
    final HashMap<Class<?>, TypeInfo> infoByClass;
    final TByteObjectHashMap<TypeInfo> infoById;

    public CustomSerializerImpl(HashMap<Class<?>, TypeInfo> infoByClass) {
        this.infoByClass = infoByClass;
        this.infoById = new TByteObjectHashMap();
        for (TypeInfo info : infoByClass.values()) {
            this.infoById.put(info.id, (Object)info);
        }
    }

    public void write(PrimitivO output, Object object) {
        Class<?> type = object.getClass();
        TypeInfo info = this.infoByClass.get(type);
        if (info == null) {
            Class<?> parent = Util.findSerializableParent(type, true, false);
            info = this.infoByClass.get(parent);
            if (info == null) {
                throw new RuntimeException("Can't find serializer for " + type);
            }
            this.infoByClass.put(type, info);
        }
        output.writeByte(info.id);
        Serializer serializer = info.serializer;
        serializer.write(output, object);
        if (!serializer.handlesReference()) {
            output.writeReference(object);
        }
    }

    public Object read(PrimitivI input) {
        byte id = input.readByte();
        Serializer serializer = ((TypeInfo)this.infoById.get((byte)id)).serializer;
        Object obj = serializer.read(input);
        if (!serializer.handlesReference()) {
            input.readReference(obj);
        }
        return obj;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public boolean handlesReference() {
        return true;
    }

    public static class TypeInfo {
        final byte id;
        final Serializer serializer;

        public TypeInfo(byte id, Serializer serializer) {
            this.id = id;
            this.serializer = serializer;
        }
    }
}

