/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.primitivio;

import com.milaboratory.primitivio.DefaultSerializersProvider;
import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.primitivio.PrimitivO;
import com.milaboratory.primitivio.Serializer;
import com.milaboratory.primitivio.SerializersManager;
import java.lang.reflect.Array;
import java.util.UUID;

public class DefaultSerializersProviderImpl
implements DefaultSerializersProvider {
    @Override
    public Serializer createSerializer(Class<?> type, SerializersManager manager) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType.isPrimitive()) {
                if (componentType == Integer.TYPE) {
                    return new IntArraySerializer();
                }
                if (componentType == Byte.TYPE) {
                    return new ByteArraySerializer();
                }
                if (componentType == Boolean.TYPE) {
                    return new BooleanArraySerializer();
                }
                return null;
            }
            return new ArraySerializer(manager.getSerializer(componentType) == null ? null : componentType);
        }
        if (type.isEnum()) {
            return new EnumSerializer(type);
        }
        if (type == Integer.class) {
            return new IntegerSerializer();
        }
        if (type == UUID.class) {
            return new UUIDSerializer();
        }
        if (type == String.class) {
            return new StringSerializer();
        }
        return null;
    }

    private static class ArraySerializer
    implements Serializer {
        final Class<?> componentType;

        private ArraySerializer(Class<?> componentType) {
            this.componentType = componentType;
        }

        public void write(PrimitivO output, Object object) {
            int length = Array.getLength(object);
            output.writeVarInt(length);
            for (int i = 0; i < length; ++i) {
                if (this.componentType == null) {
                    output.writeObject(Array.get(object, i));
                    continue;
                }
                output.writeObject(Array.get(object, i), this.componentType);
            }
        }

        public Object read(PrimitivI input) {
            int length = input.readVarInt();
            if (this.componentType == null) {
                throw new RuntimeException("Unknown array type.");
            }
            Object array = Array.newInstance(this.componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, input.readObject(this.componentType));
            }
            return array;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    private static class UUIDSerializer
    implements Serializer<UUID> {
        private UUIDSerializer() {
        }

        @Override
        public void write(PrimitivO output, UUID object) {
            output.writeLong(object.getMostSignificantBits());
            output.writeLong(object.getLeastSignificantBits());
        }

        @Override
        public UUID read(PrimitivI input) {
            long msb = input.readLong();
            long lsb = input.readLong();
            return new UUID(msb, lsb);
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    public static final class CustomEnumSerializer<E extends Enum<E>>
    implements Serializer {
        final Class<E> enumType;
        final E[] array;

        public CustomEnumSerializer(Class<E> enumType, E ... valuesByOrdinal) {
            this.enumType = enumType;
            this.array = valuesByOrdinal;
        }

        public void write(PrimitivO output, Object object) {
            throw new IllegalStateException("Not implemented.");
        }

        public Object read(PrimitivI input) {
            return this.array[input.readVarInt()];
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    private static class EnumSerializer
    implements Serializer {
        final Class<?> enumType;
        final Object[] array;

        private EnumSerializer(Class<?> enumType) {
            this.enumType = enumType;
            this.array = new Object[enumType.getEnumConstants().length];
            System.arraycopy(enumType.getEnumConstants(), 0, this.array, 0, this.array.length);
        }

        public void write(PrimitivO output, Object object) {
            Enum e = (Enum)object;
            output.writeVarInt(e.ordinal());
        }

        public Object read(PrimitivI input) {
            return this.array[input.readVarInt()];
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    private static class BooleanArraySerializer
    implements Serializer<boolean[]> {
        private BooleanArraySerializer() {
        }

        @Override
        public void write(PrimitivO output, boolean[] object) {
            output.writeVarInt(object.length);
            for (int i = 0; i < object.length; ++i) {
                output.writeBoolean(object[i]);
            }
        }

        @Override
        public boolean[] read(PrimitivI input) {
            boolean[] object = new boolean[input.readVarInt()];
            for (int i = 0; i < object.length; ++i) {
                object[i] = input.readBoolean();
            }
            return object;
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    private static class ByteArraySerializer
    implements Serializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public void write(PrimitivO output, byte[] object) {
            output.writeVarInt(object.length);
            output.write(object);
        }

        @Override
        public byte[] read(PrimitivI input) {
            byte[] object = new byte[input.readVarInt()];
            input.readFully(object);
            return object;
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    private static class IntArraySerializer
    implements Serializer<int[]> {
        private IntArraySerializer() {
        }

        @Override
        public void write(PrimitivO output, int[] object) {
            output.writeVarInt(object.length);
            for (int i : object) {
                output.writeInt(i);
            }
        }

        @Override
        public int[] read(PrimitivI input) {
            int[] object = new int[input.readVarInt()];
            for (int i = 0; i < object.length; ++i) {
                object[i] = input.readInt();
            }
            return object;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    private static class StringSerializer
    implements Serializer<String> {
        private StringSerializer() {
        }

        @Override
        public void write(PrimitivO output, String object) {
            output.writeUTF(object);
        }

        @Override
        public String read(PrimitivI input) {
            return input.readUTF();
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    private static class IntegerSerializer
    implements Serializer<Integer> {
        private IntegerSerializer() {
        }

        @Override
        public void write(PrimitivO output, Integer object) {
            output.writeInt(object);
        }

        @Override
        public Integer read(PrimitivI input) {
            return input.readInt();
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }
}

