/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.primitivio;

import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.CountingInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class PReader
implements CanReportProgress,
AutoCloseable {
    protected final PrimitivI input;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final CountingInputStream countingInputStream;
    protected final long totalSize;

    protected PReader(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    protected PReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    protected PReader(FileInputStream stream) throws IOException {
        this.countingInputStream = new CountingInputStream(new BufferedInputStream(stream, 32768));
        this.input = new PrimitivI(this.countingInputStream);
        this.totalSize = stream.getChannel().size();
    }

    protected PReader(InputStream stream) {
        this(stream, -1L);
    }

    protected PReader(InputStream stream, long totalSize) {
        this.countingInputStream = new CountingInputStream(stream);
        this.input = new PrimitivI(this.countingInputStream);
        this.totalSize = totalSize;
    }

    @Override
    public double getProgress() {
        return 1.0 * (double)this.countingInputStream.getBytesRead() / (double)this.totalSize;
    }

    @Override
    public boolean isFinished() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.input.close();
        }
    }
}

