/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.primitivio;

import com.milaboratory.primitivio.Serializer;
import com.milaboratory.primitivio.SerializersManager;
import com.milaboratory.primitivio.Util;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public final class PrimitivI
implements DataInput,
AutoCloseable {
    final DataInput input;
    final SerializersManager manager;
    final ArrayList<Object> references = new ArrayList();
    final ArrayList<Object> putKnownAfterReset = new ArrayList();
    int knownReferencesCount = 0;
    int depth = 0;

    public PrimitivI(InputStream input) {
        this(new DataInputStream(input), new SerializersManager());
    }

    public PrimitivI(DataInput input) {
        this(input, new SerializersManager());
    }

    public PrimitivI(DataInput input, SerializersManager manager) {
        this.input = input;
        this.manager = manager;
    }

    public SerializersManager getSerializersManager() {
        return this.manager;
    }

    public void putKnownReference(Object ref) {
        if (this.depth > 0) {
            this.putKnownAfterReset.add(ref);
        } else {
            this.references.add(ref);
            ++this.knownReferencesCount;
        }
    }

    public void readReference(Object ref) {
        int id = this.readVarInt();
        if (id != this.references.size()) {
            throw new RuntimeException("wrong reference id.");
        }
        this.references.add(ref);
    }

    private void reset() {
        for (int i = this.references.size() - 1; i >= this.knownReferencesCount; --i) {
            this.references.remove(i);
        }
        if (!this.putKnownAfterReset.isEmpty()) {
            for (Object ref : this.putKnownAfterReset) {
                this.putKnownReference(ref);
            }
            this.putKnownAfterReset.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Class<T> type) {
        Serializer<T> serializer = this.manager.getSerializer(type);
        if (serializer.isReference()) {
            int id = this.readVarInt();
            if (id == 0) {
                return null;
            }
            if (id == 1) {
                boolean readReferenceAfter = !serializer.handlesReference();
                ++this.depth;
                try {
                    T obj = serializer.read(this);
                    if (readReferenceAfter) {
                        this.readReference(obj);
                    }
                    T t = obj;
                    return t;
                }
                finally {
                    --this.depth;
                    if (this.depth == 0) {
                        this.reset();
                    }
                }
            }
            Object obj = this.references.get(id - 2);
            if (!type.isInstance(obj)) {
                throw new RuntimeException("Wrong file format.");
            }
            return (T)obj;
        }
        ++this.depth;
        try {
            T t = serializer.read(this);
            return t;
        }
        finally {
            --this.depth;
            if (this.depth == 0) {
                this.reset();
            }
        }
    }

    public long readVarLongZigZag() {
        return Util.zigZagDecodeLong(this.readVarLong());
    }

    public long readVarLong() {
        long tmp;
        long value = 0L;
        int shift = 0;
        do {
            tmp = this.readByte();
            value |= (tmp & 0x7FL) << shift;
            shift += 7;
        } while ((tmp & 0x80L) != 0L);
        return value;
    }

    public int readVarIntZigZag() {
        return Util.zigZagDecodeInt(this.readVarInt());
    }

    public int readVarInt() {
        byte tmp;
        int value = 0;
        int shift = 0;
        do {
            tmp = this.readByte();
            value |= (tmp & 0x7F) << shift;
            shift += 7;
        } while ((tmp & 0x80) != 0);
        return value;
    }

    @Override
    public void readFully(byte[] b) {
        try {
            this.input.readFully(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        try {
            this.input.readFully(b, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int skipBytes(int n) {
        try {
            return this.input.skipBytes(n);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.input.readBoolean();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readByte() {
        try {
            return this.input.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUnsignedByte() {
        try {
            return this.input.readUnsignedByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readShort() {
        try {
            return this.input.readShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUnsignedShort() {
        try {
            return this.input.readUnsignedShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public char readChar() {
        try {
            return this.input.readChar();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt() {
        try {
            return this.input.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.input.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.input.readFloat();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.input.readDouble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        try {
            return this.input.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.input instanceof Closeable) {
                ((Closeable)((Object)this.input)).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

