/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.primitivio;

import com.milaboratory.primitivio.Serializer;
import com.milaboratory.primitivio.SerializersManager;
import com.milaboratory.primitivio.Util;
import gnu.trove.map.custom_hash.TObjectIntCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class PrimitivO
implements DataOutput,
AutoCloseable {
    static final int NULL_ID = 0;
    static final int NEW_OBJECT_ID = 1;
    static final int ID_OFFSET = 2;
    private static final float RELOAD_FACTOR = 0.5f;
    final DataOutput output;
    final SerializersManager manager;
    final ArrayList<Object> putKnownAfterReset = new ArrayList();
    final TObjectIntCustomHashMap<Object> knownReferences = new TObjectIntCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE, 10, 0.5f, Integer.MIN_VALUE);
    final ArrayList<Object> addedReferences = new ArrayList();
    int depth = 0;
    TObjectIntCustomHashMap<Object> currentReferences = null;

    public PrimitivO(OutputStream output) {
        this(new DataOutputStream(output), new SerializersManager());
    }

    public PrimitivO(DataOutput output) {
        this(output, new SerializersManager());
    }

    public PrimitivO(DataOutput output, SerializersManager manager) {
        this.output = output;
        this.manager = manager;
    }

    public SerializersManager getSerializersManager() {
        return this.manager;
    }

    private void ensureCurrentReferencesInitialized() {
        if (this.currentReferences == null) {
            this.currentReferences = new TObjectIntCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE, this.knownReferences);
        }
    }

    public void putKnownReference(Object object) {
        if (this.depth > 0) {
            this.putKnownAfterReset.add(object);
        } else {
            this.knownReferences.put(object, this.knownReferences.size());
            this.currentReferences = null;
        }
    }

    private void reset() {
        if (this.currentReferences != null && this.currentReferences.size() != this.knownReferences.size()) {
            if ((float)(this.currentReferences.size() - this.knownReferences.size()) * 0.5f > (float)this.knownReferences.size()) {
                this.currentReferences = null;
            } else {
                for (Object ref : this.addedReferences) {
                    this.currentReferences.remove(ref);
                }
            }
            this.addedReferences.clear();
        }
        if (!this.putKnownAfterReset.isEmpty()) {
            for (Object ref : this.putKnownAfterReset) {
                this.putKnownReference(ref);
            }
            this.putKnownAfterReset.clear();
        }
    }

    private int addCurrentReference(Object ref) {
        int id = this.currentReferences.size();
        this.currentReferences.put(ref, id);
        this.addedReferences.add(ref);
        return id;
    }

    public void writeReference(Object ref) {
        int id = this.addCurrentReference(ref);
        this.writeVarInt(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObject(Object object, Class<?> type) {
        Serializer<?> serializer = this.manager.getSerializer(type);
        if (object == null) {
            if (!serializer.isReference()) throw new IllegalArgumentException("Non-reference type can't be null.");
            this.writeNull();
            return;
        }
        if (this.depth == 0) {
            this.ensureCurrentReferencesInitialized();
        }
        boolean writeIdAfter = false;
        if (serializer.isReference()) {
            int id = this.currentReferences.get(object);
            if (id != Integer.MIN_VALUE) {
                this.writeObjectReference(id);
                return;
            }
            this.writeNewObject();
            writeIdAfter = !serializer.handlesReference();
        }
        ++this.depth;
        try {
            serializer.write(this, object);
            if (!writeIdAfter) return;
            this.writeReference(object);
            return;
        }
        finally {
            --this.depth;
            if (this.depth == 0) {
                this.reset();
            }
        }
    }

    private void writeNull() {
        this.writeByte(0);
    }

    private void writeNewObject() {
        this.writeByte(1);
    }

    private void writeObjectReference(int value) {
        this.writeVarInt(value + 2);
    }

    public void writeVarIntZigZag(int value) {
        this.writeVarInt(Util.zigZagEncodeInt(value));
    }

    public void writeVarInt(int value) {
        this.writeVarLong(0xFFFFFFFFL & (long)value);
    }

    public void writeVarLongZigZag(long value) {
        this.writeVarLong(Util.zigZagEncodeLong(value));
    }

    public void writeVarLong(long value) {
        do {
            int toWrite = (int)(value & 0x7FL);
            if ((value >>>= 7) != 0L) {
                toWrite |= 0x80;
            }
            this.writeByte(toWrite);
        } while (value != 0L);
    }

    public void writeObject(Object object) {
        if (object == null) {
            this.writeByte(0);
        } else {
            this.writeObject(object, object.getClass());
        }
    }

    @Override
    public void write(int b) {
        try {
            this.output.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(byte[] b) {
        try {
            this.output.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        try {
            this.output.write(b, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        try {
            this.output.writeBoolean(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeByte(int v) {
        try {
            this.output.writeByte(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeShort(int v) {
        try {
            this.output.writeShort(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeChar(int v) {
        try {
            this.output.writeChar(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeInt(int v) {
        try {
            this.output.writeInt(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeLong(long v) {
        try {
            this.output.writeLong(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeFloat(float v) {
        try {
            this.output.writeFloat(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeDouble(double v) {
        try {
            this.output.writeDouble(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeBytes(String s) {
        try {
            this.output.writeBytes(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeChars(String s) {
        try {
            this.output.writeChars(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeUTF(String s) {
        try {
            this.output.writeUTF(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.output instanceof Closeable) {
                ((Closeable)((Object)this.output)).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

