/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.primitivio;

import com.milaboratory.primitivio.CustomSerializerImpl;
import com.milaboratory.primitivio.DefaultSerializersProvider;
import com.milaboratory.primitivio.DefaultSerializersProviderImpl;
import com.milaboratory.primitivio.JSONSerializer;
import com.milaboratory.primitivio.Serializer;
import com.milaboratory.primitivio.Util;
import com.milaboratory.primitivio.annotations.CustomSerializer;
import com.milaboratory.primitivio.annotations.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class SerializersManager {
    final DefaultSerializersProvider defaultSerializersProvider = new DefaultSerializersProviderImpl();
    final HashMap<Class<?>, Serializer> registeredHelpers = new HashMap();

    public <T> Serializer<? super T> getSerializer(Class<T> type) {
        Class<?> parent;
        Serializer serializer = this.registeredHelpers.get(type);
        if (serializer == null && (serializer = this.registeredHelpers.get(parent = Util.findSerializableParent(type, true, false))) != null) {
            this.registeredHelpers.put(type, serializer);
        }
        if (serializer != null) {
            return serializer;
        }
        return this.createAndRegisterSerializer(type);
    }

    public void registerCustomSerializer(Class<?> type, Serializer<?> customSerializer) {
        this.registeredHelpers.put(type, customSerializer);
    }

    private Serializer createAndRegisterSerializer(Class<?> type) {
        Serializer serializer;
        Class<?> root = SerializersManager.findRoot(type);
        if (root == null) {
            serializer = this.defaultSerializersProvider.createSerializer(type, this);
            if (serializer == null) {
                throw new RuntimeException("" + type + " is not serializable.");
            }
            root = type;
        } else {
            serializer = this.createSerializer0(root, false);
        }
        this.registeredHelpers.put(root, serializer);
        if (type != root) {
            this.registeredHelpers.put(type, serializer);
        }
        if (serializer instanceof CustomSerializerImpl) {
            for (Class<?> subType : ((CustomSerializerImpl)serializer).infoByClass.keySet()) {
                this.registeredHelpers.put(subType, serializer);
            }
        }
        return serializer;
    }

    private Serializer createSerializer0(Class<?> type, boolean nested) {
        CustomSerializer[] css;
        Serializer defaultSerializer;
        Serializable annotation = type.getAnnotation(Serializable.class);
        if (annotation == null) {
            throw new IllegalArgumentException("" + type + " is not serializable.");
        }
        Serializer serializer = defaultSerializer = annotation.by() == Serializer.class ? null : SerializersManager.instantiate(annotation.by());
        if (annotation.asJson()) {
            if (defaultSerializer != null) {
                throw new RuntimeException("'asJson' and 'by' parameters are not compatible.");
            }
            defaultSerializer = new JSONSerializer(type);
        }
        if ((css = annotation.custom()).length > 0) {
            if (nested) {
                throw new RuntimeException("Nested custom serializers in " + type + ".");
            }
            HashMap infoByClass = new HashMap();
            if (defaultSerializer != null) {
                infoByClass.put(type, new CustomSerializerImpl.TypeInfo(0, defaultSerializer));
            }
            for (CustomSerializer cs : css) {
                infoByClass.put(cs.type(), new CustomSerializerImpl.TypeInfo(cs.id(), this.createSerializer0(cs.type(), true)));
            }
            return new CustomSerializerImpl(infoByClass);
        }
        if (defaultSerializer == null) {
            throw new RuntimeException("No serializer for " + type);
        }
        return defaultSerializer;
    }

    static Serializer instantiate(Class<? extends Serializer> cl) {
        boolean initialAccessibility = true;
        Constructor<? extends Serializer> constructor = null;
        try {
            constructor = cl.getConstructor(new Class[0]);
            initialAccessibility = constructor.isAccessible();
            if (!initialAccessibility) {
                constructor.setAccessible(true);
            }
            Serializer serializer = cl.newInstance();
            return serializer;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!initialAccessibility && constructor != null) {
                constructor.setAccessible(false);
            }
        }
    }

    static Class<?> findRoot(Class<?> type) {
        List<Class<?>> serializableClasses = SerializersManager.getAllSerializableInTree(type);
        if (serializableClasses.isEmpty()) {
            return null;
        }
        Class<?> realRoot = SerializersManager.findRealRoot(serializableClasses.get(0));
        for (int i = 1; i < serializableClasses.size(); ++i) {
            Class<?> tmp = SerializersManager.findRealRoot(serializableClasses.get(i));
            if (Objects.equals(tmp, realRoot)) continue;
            throw new IllegalArgumentException("Conflict between " + realRoot + " and " + tmp + " through " + serializableClasses.get(i));
        }
        return realRoot;
    }

    private static List<Class<?>> getAllSerializableInTree(Class<?> type) {
        ArrayList list = new ArrayList();
        SerializersManager.addAllSerializableInTree(type, list);
        return list;
    }

    private static void addAllSerializableInTree(Class<?> type, List<Class<?>> list) {
        Class<?> superclass;
        if (type.getAnnotation(Serializable.class) != null) {
            list.add(type);
        }
        if ((superclass = type.getSuperclass()) != null) {
            SerializersManager.addAllSerializableInTree(superclass, list);
        }
        for (Class<?> cInterface : type.getInterfaces()) {
            SerializersManager.addAllSerializableInTree(cInterface, list);
        }
    }

    private static Class<?> findRealRoot(Class<?> type) {
        Class<?> tmp = Util.findSerializableParent(type, false, true);
        if (tmp != null) {
            return tmp;
        }
        tmp = Util.findSerializableParent(type, false, false);
        return tmp;
    }
}

