/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.primitivio;

import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.primitivio.PrimitivO;
import com.milaboratory.primitivio.annotations.Serializable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Util {
    private Util() {
    }

    static Class<?> findSerializableParent(Class<?> type, boolean direct, boolean withCustomSerializersOnly) {
        Class<?> tmp;
        Class<?> superclass;
        Class<?> root = null;
        Serializable a = type.getAnnotation(Serializable.class);
        if (!(a == null || withCustomSerializersOnly && a.custom().length <= 0)) {
            if (direct) {
                return type;
            }
            root = type;
        }
        if ((superclass = type.getSuperclass()) != null && (tmp = Util.findSerializableParent(superclass, direct, withCustomSerializersOnly)) != null) {
            if (root == null) {
                root = tmp;
            } else {
                throw new RuntimeException("Custom serializers conflict: " + root + " and " + tmp + " through " + type);
            }
        }
        for (Class<?> cInterface : type.getInterfaces()) {
            tmp = Util.findSerializableParent(cInterface, direct, withCustomSerializersOnly);
            if (tmp == null) continue;
            if (root == null || root == tmp) {
                root = tmp;
                continue;
            }
            throw new RuntimeException("Custom serializers conflict: " + root + " and " + tmp + " through " + type);
        }
        return root;
    }

    public static void writeList(List<?> list, String fileName) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileName));){
            Util.writeList(list, stream);
        }
    }

    public static void writeList(List<?> list, File file) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            Util.writeList(list, stream);
        }
    }

    public static void writeList(List<?> list, OutputStream output) {
        Util.writeList(list, new PrimitivO(output));
    }

    public static void writeList(List<?> list, PrimitivO output) {
        output.writeInt(list.size());
        for (Object o : list) {
            output.writeObject(o);
        }
    }

    public static <O> List<O> readList(Class<O> type, String fileName) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(fileName));){
            List<O> list = Util.readList(type, stream);
            return list;
        }
    }

    public static <O> List<O> readList(Class<O> type, File file) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            List<O> list = Util.readList(type, stream);
            return list;
        }
    }

    public static <O> List<O> readList(Class<O> type, InputStream is) {
        return Util.readList(type, new PrimitivI(is));
    }

    public static <O> List<O> readList(Class<O> type, PrimitivI input) {
        int size = input.readInt();
        ArrayList<O> list = new ArrayList<O>(size);
        while (--size >= 0) {
            list.add(input.readObject(type));
        }
        return list;
    }

    public static <K, V> void writeMap(Map<K, V> map, PrimitivO output) {
        output.writeVarInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            output.writeObject(entry.getKey());
            output.writeObject(entry.getValue());
        }
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> readEnumMap(PrimitivI input, Class<K> keyClass, Class<V> valueClass) {
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(keyClass);
        for (int size = input.readVarInt(); size > 0; --size) {
            Enum key = (Enum)input.readObject(keyClass);
            V value = input.readObject(valueClass);
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> Map<K, V> readMap(PrimitivI input, Class<K> keyClass, Class<V> valueClass) {
        int size;
        HashMap<K, V> map = new HashMap<K, V>(size);
        for (size = input.readVarInt(); size > 0; --size) {
            K key = input.readObject(keyClass);
            V value = input.readObject(valueClass);
            map.put(key, value);
        }
        return map;
    }

    public static long zigZagEncodeLong(long value) {
        return value << 1 ^ value >> 63;
    }

    public static long zigZagDecodeLong(long value) {
        return value >>> 1 ^ value << 63 >> 63;
    }

    public static int zigZagEncodeInt(int value) {
        return value << 1 ^ value >> 31;
    }

    public static int zigZagDecodeInt(int value) {
        return value >>> 1 ^ value << 31 >> 31;
    }
}

