/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.test;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.VoidProcessor;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.fastq.SingleFastqReader;
import com.milaboratory.util.SmartProgressReporter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;

public class Read {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");

    public static void main(String[] args) throws IOException, InterruptedException {
        long numberOfReads = 0L;
        long time = System.nanoTime();
        final AtomicLong count = new AtomicLong();
        final AtomicLong g = new AtomicLong();
        try (SingleFastqReader reader = new SingleFastqReader(args[0], args[1].equals("true"));){
            SmartProgressReporter.startProgressReport("Reading: ", reader);
            SingleFastqReader input = reader;
            if (args[2].equals("true")) {
                input = CUtils.buffered((OutputPort)input, (int)1024);
            }
            CUtils.processAllInParallel((OutputPort)input, (VoidProcessor)new VoidProcessor<SingleRead>(){

                public void process(SingleRead singleRead) {
                    count.incrementAndGet();
                    g.addAndGet(singleRead.getData().hashCode());
                    g.addAndGet(singleRead.getDescription().hashCode());
                }
            }, (int)Integer.parseInt(args[3], 10));
        }
        numberOfReads = count.get();
        System.out.println("Number of reads: " + numberOfReads);
        System.out.println("Time: " + Read.time(System.nanoTime() - time));
        System.out.println("Time per read: " + Read.time((System.nanoTime() - time) / numberOfReads));
    }

    public static String time(long t) {
        double v = t;
        if ((t /= 1000L) == 0L) {
            return "" + DECIMAL_FORMAT.format(v) + "ns";
        }
        v /= 1000.0;
        if ((t /= 1000L) == 0L) {
            return "" + DECIMAL_FORMAT.format(v) + "us";
        }
        v /= 1000.0;
        if ((t /= 1000L) == 0L) {
            return "" + DECIMAL_FORMAT.format(v) + "ms";
        }
        v /= 1000.0;
        if ((t /= 60L) == 0L) {
            return "" + DECIMAL_FORMAT.format(v) + "s";
        }
        return "" + DECIMAL_FORMAT.format(v /= 60.0) + "m";
    }
}

