/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import com.milaboratory.util.LongProcess;
import com.milaboratory.util.LongProcessReporter;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractLongProcessReporter
implements LongProcessReporter {
    public static final long DEFAULT_REPORTING_INTERVAL = 1000000000L;
    public static final double DEFAULT_REPORTING_PROGRESS_DELTA = 0.1;
    final AtomicLong counter = new AtomicLong();
    final long minimalReportingInterval;
    final double minimalReportingProgressDelta;
    private static final DecimalFormat percentFormat = new DecimalFormat("##.#'%'");

    public AbstractLongProcessReporter() {
        this(1000000000L, 0.1);
    }

    public AbstractLongProcessReporter(long minimalReportingInterval, double minimalReportingProgressDelta) {
        this.minimalReportingInterval = minimalReportingInterval;
        this.minimalReportingProgressDelta = minimalReportingProgressDelta;
    }

    public abstract void report(long var1, String var3, double var4);

    @Override
    public LongProcess start(final String name) {
        final long id = this.counter.getAndIncrement();
        this.report(id, name, 0.0);
        return new LongProcess(){
            final AtomicLong previousTimestamp = new AtomicLong(System.nanoTime());
            volatile double previousProgress = 0.0;

            @Override
            public void reportStatus(double progress) {
                long pt;
                if (progress < this.previousProgress + AbstractLongProcessReporter.this.minimalReportingProgressDelta) {
                    return;
                }
                long timestamp = System.nanoTime();
                if (timestamp < (pt = this.previousTimestamp.get()) + AbstractLongProcessReporter.this.minimalReportingInterval) {
                    return;
                }
                if (this.previousTimestamp.compareAndSet(pt, timestamp)) {
                    this.previousProgress = progress;
                    AbstractLongProcessReporter.this.report(id, name, progress);
                }
            }

            @Override
            public void close() {
                AbstractLongProcessReporter.this.report(id, name, Double.POSITIVE_INFINITY);
            }
        };
    }

    public static LongProcessReporter stderrReporter() {
        return new AbstractLongProcessReporter(){

            @Override
            public void report(long id, String name, double progress) {
                String status = Double.POSITIVE_INFINITY == progress ? "done" : percentFormat.format(progress * 100.0);
                System.err.println(name + ": " + status);
            }
        };
    }
}

