/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArraysUtils {
    private ArraysUtils() {
    }

    public static void reverse(int[] array, int from, int to) {
        int length = to - from;
        for (int i = 0; i < (length + 1) / 2; ++i) {
            int v = array[from + i];
            array[from + i] = array[from + length - i - 1];
            array[from + length - i - 1] = v;
        }
    }

    public static void reverse(int[] array) {
        for (int i = 0; i < (array.length + 1) / 2; ++i) {
            int v = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = v;
        }
    }

    public static void reverse(byte[] array) {
        for (int i = 0; i < (array.length + 1) / 2; ++i) {
            byte v = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = v;
        }
    }

    public static long[] getSortedDistinct(long[] values) {
        if (values.length == 0) {
            return values;
        }
        Arrays.sort(values);
        int shift = 0;
        int i = 0;
        while (i + shift + 1 < values.length) {
            if (values[i + shift] == values[i + shift + 1]) {
                ++shift;
                continue;
            }
            values[i] = values[i + shift];
            ++i;
        }
        values[i] = values[i + shift];
        return Arrays.copyOf(values, i + 1);
    }

    public static int[] concatenate(int[] array1, int ... array2) {
        int[] r = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, r, 0, array1.length);
        System.arraycopy(array2, 0, r, array1.length, array2.length);
        return r;
    }

    public static long[] concatenate(long[] array1, long ... array2) {
        long[] r = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, r, 0, array1.length);
        System.arraycopy(array2, 0, r, array1.length, array2.length);
        return r;
    }

    public static <T> T[] concatenate(T[] array1, T ... array2) {
        Class<?> ct = array1.getClass().getComponentType();
        if (!ct.equals(array2.getClass().getComponentType())) {
            throw new IllegalArgumentException("Different runtime types.");
        }
        Object[] r = (Object[])Array.newInstance(ct, array1.length + array2.length);
        System.arraycopy(array1, 0, r, 0, array1.length);
        System.arraycopy(array2, 0, r, array1.length, array2.length);
        return r;
    }
}

