/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.milaboratory.util.GlobalObjectMappers;
import java.util.concurrent.atomic.AtomicLongArray;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public final class AtomicEnumHistogram<E extends Enum<E>> {
    private final Class<E> enumClass;
    private final AtomicLongArray hist;

    public AtomicEnumHistogram(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.hist = new AtomicLongArray(((Enum[])enumClass.getEnumConstants()).length + 1);
    }

    public void add(E value) {
        if (value == null) {
            this.hist.incrementAndGet(this.hist.length() - 1);
        } else {
            this.hist.incrementAndGet(((Enum)value).ordinal());
        }
    }

    public String[] getLabels() {
        String[] labels = new String[((Enum[])this.enumClass.getEnumConstants()).length + 1];
        int i = 0;
        for (Enum e : (Enum[])this.enumClass.getEnumConstants()) {
            labels[i++] = e.name();
        }
        labels[i] = "null";
        return labels;
    }

    public long[] getHist() {
        long[] result = new long[this.hist.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.hist.get(i);
        }
        return result;
    }

    @JsonUnwrapped
    @JsonValue
    public SerializableResult getSerializableResult() {
        return new SerializableResult(this.getLabels(), this.getHist());
    }

    public String toString() {
        try {
            return GlobalObjectMappers.toOneLine(this.getSerializableResult());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
    public static final class SerializableResult {
        public final String[] labels;
        public final long[] hist;

        public SerializableResult(String[] labels, long[] hist) {
            this.labels = labels;
            this.hist = hist;
        }
    }
}

