/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.milaboratory.util.GlobalObjectMappers;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public final class AtomicHistogram {
    private final double[] boundaries;
    private final AtomicLong total = new AtomicLong();
    private final AtomicLongArray hist;

    public AtomicHistogram(double[] boundaries) {
        this.boundaries = boundaries;
        this.hist = new AtomicLongArray(boundaries.length - 1);
    }

    public AtomicHistogram(int lower, int upper) {
        this((double)lower - 0.5, (double)upper + 0.5, upper - lower + 1);
    }

    public AtomicHistogram(double lower, double upper, int bins) {
        this(AtomicHistogram.bins(lower, upper, bins));
    }

    public void add(double value) {
        this.total.incrementAndGet();
        if (value < this.boundaries[0] || this.boundaries[this.boundaries.length - 1] < value) {
            return;
        }
        int i = Arrays.binarySearch(this.boundaries, value);
        if (i < 0) {
            i = -1 - i;
        }
        if (i > 0) {
            --i;
        }
        this.hist.incrementAndGet(i);
    }

    public double[] getBoundaries() {
        return (double[])this.boundaries.clone();
    }

    public long[] getHist() {
        long[] result = new long[this.hist.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.hist.get(i);
        }
        return result;
    }

    public long getTotalCountInHist() {
        long result = 0L;
        for (int i = 0; i < this.hist.length(); ++i) {
            result += this.hist.get(i);
        }
        return result;
    }

    public double mean() {
        double sum = 0.0;
        long totalCount = 0L;
        for (int i = 0; i < this.hist.length(); ++i) {
            sum += (double)this.hist.get(i) * (this.boundaries[i] + this.boundaries[i + 1]) / 2.0;
            totalCount += this.hist.get(i);
        }
        return sum / (double)totalCount;
    }

    public double getCoveredFraction() {
        return 1.0 * (double)this.getTotalCountInHist() / (double)this.getTotalProcessed();
    }

    public long getTotalProcessed() {
        return this.total.get();
    }

    static double[] bins(double lower, double upper, int bins) {
        double[] result = new double[bins + 1];
        double step = (upper - lower) / (double)bins;
        for (int i = 0; i < bins; ++i) {
            result[i] = lower + (double)i * step;
        }
        result[bins] = upper;
        return result;
    }

    @JsonUnwrapped
    @JsonValue
    public SerializableResult getSerializableResult() {
        return new SerializableResult(this.getBoundaries(), this.getTotalProcessed(), this.getHist(), this.getCoveredFraction());
    }

    public String toString() {
        try {
            return GlobalObjectMappers.toOneLine(this.getSerializableResult());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
    public static final class SerializableResult {
        public final double[] boundaries;
        public final long total;
        public final long[] hist;
        public final double coveredFraction;

        public SerializableResult(double[] boundaries, long total, long[] hist, double coveredFraction) {
            this.boundaries = boundaries;
            this.total = total;
            this.hist = hist;
            this.coveredFraction = coveredFraction;
        }
    }
}

