/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public final class Bit2Array
implements Serializable {
    private static final long serialVersionUID = 1L;
    byte[] data;
    int size;

    public Bit2Array(int length) {
        this.size = length;
        this.data = new byte[length + 3 >> 2];
    }

    Bit2Array(int size, byte[] data) {
        this.size = size;
        this.data = data;
    }

    public int size() {
        return this.size;
    }

    public int get(int index) {
        return this.data[index >> 2] >>> ((index & 3) << 1) & 3;
    }

    public void set(int index, int value) {
        int n = index >> 2;
        this.data[n] = (byte)(this.data[n] & ~(3 << ((index & 3) << 1)));
        int n2 = index >> 2;
        this.data[n2] = (byte)(this.data[n2] | (value & 3) << ((index & 3) << 1));
    }

    public Bit2Array clone() {
        return new Bit2Array(this.size, Arrays.copyOf(this.data, this.data.length));
    }

    public Bit2Array extend(int size) {
        if (size < this.size) {
            throw new IllegalArgumentException();
        }
        return new Bit2Array(size, Arrays.copyOf(this.data, size + 3 >> 2));
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            data[i] = (byte)this.get(i);
        }
        return data;
    }

    public void copyFrom(Bit2Array other, int otherOffset, int thisOffset, int length) {
        if (thisOffset < 0 || thisOffset + length > this.size || otherOffset < 0 || otherOffset + length > other.size) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            this.set(thisOffset + i, other.get(otherOffset + i));
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Arrays.hashCode(this.data);
        hash = 47 * hash + this.size;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bit2Array other = (Bit2Array)obj;
        if (this.size != other.size) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public Bit2Array getRange(int from, int to) {
        if (from < 0 || from >= this.size && this.size != 0 || to < from || to > this.size) {
            throw new IndexOutOfBoundsException("from=" + from + ", to=" + to);
        }
        Bit2Array ret = new Bit2Array(to - from);
        int i = 0;
        int j = from;
        while (j < to) {
            ret.set(i, this.get(j));
            ++j;
            ++i;
        }
        return ret;
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeInt(this.size);
        output.write(this.data);
    }

    public static Bit2Array readFrom(DataInput input) throws IOException {
        int size = input.readInt();
        byte[] buf = new byte[size + 3 >> 2];
        input.readFully(buf);
        return new Bit2Array(size, buf);
    }

    public static byte[] extractRawDataArray(Bit2Array array) {
        return array.data;
    }

    public static Bit2Array construct(int size, byte[] data) {
        return new Bit2Array(size, data);
    }
}

