/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class BitArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    byte[] data;
    int size;

    public BitArray(List<Boolean> booleans) {
        this(booleans.size());
        for (int i = booleans.size() - 1; i >= 0; --i) {
            if (!booleans.get(i).booleanValue()) continue;
            this.set(i);
        }
    }

    public BitArray(boolean ... array) {
        this(array.length);
        for (int i = array.length - 1; i >= 0; --i) {
            if (!array[i]) continue;
            this.set(i);
        }
    }

    public BitArray(int size) {
        this.size = size;
        this.data = new byte[size + 7 >> 3];
    }

    BitArray(byte[] data, int size) {
        this.data = data;
        this.size = size;
    }

    public boolean get(int i) {
        return (this.data[i >> 3] & 1 << (i & 7)) != 0;
    }

    public void set(int i) {
        int n = i >> 3;
        this.data[n] = (byte)(this.data[n] | 1 << (i & 7));
    }

    public void clear(int i) {
        int n = i >> 3;
        this.data[n] = (byte)(this.data[n] & ~(1 << (i & 7)));
    }

    public void set(int i, boolean value) {
        if (value) {
            this.set(i);
        } else {
            this.clear(i);
        }
    }

    public BitArray getRange(int from, int to) {
        BitArray ret = new BitArray(to - from);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, this.get(i + from));
        }
        return ret;
    }

    public void set(BitArray ba) {
        if (ba.size != this.size) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = ba.data[i];
        }
    }

    public void setAll() {
        Arrays.fill(this.data, (byte)-1);
        if ((this.size & 7) != 0) {
            this.data[this.data.length - 1] = (byte)(255 >>> 8 - (this.size & 7));
        }
    }

    public boolean intersects(BitArray bitArray) {
        if (bitArray.size != this.size) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.data.length; ++i) {
            if ((this.data[i] & bitArray.data[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public int bitCount() {
        int count = 0;
        for (int i = 0; i < this.data.length; ++i) {
            count += Integer.bitCount(0xFF & this.data[i]);
        }
        return count;
    }

    public void or(BitArray bitArray) {
        if (this.size != bitArray.size) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = (byte)(this.data[n] | bitArray.data[i]);
        }
    }

    public void xor(BitArray bitArray) {
        if (this.size != bitArray.size) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = (byte)(this.data[n] ^ bitArray.data[i]);
        }
    }

    public void and(BitArray bitArray) {
        if (this.size != bitArray.size) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = (byte)(this.data[n] & bitArray.data[i]);
        }
    }

    public void loadValueFrom(BitArray bitArray) {
        if (this.size != bitArray.size) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(bitArray.data, 0, this.data, 0, bitArray.data.length);
    }

    public boolean isClean() {
        for (byte d : this.data) {
            if (d == 0) continue;
            return false;
        }
        return true;
    }

    public void clearAll() {
        Arrays.fill(this.data, (byte)0);
    }

    public int[] getBits() {
        int[] bits = new int[this.bitCount()];
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!this.get(i)) continue;
            bits[n++] = i;
        }
        return bits;
    }

    public int size() {
        return this.size;
    }

    public BitArray clone() {
        return new BitArray(Arrays.copyOf(this.data, this.data.length), this.size);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitArray other = (BitArray)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return this.size == other.size;
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + Arrays.hashCode(this.data);
        hash = 19 * hash + this.size;
        return hash;
    }

    public String toString() {
        char[] c = new char[this.size];
        for (int i = 0; i < this.size; ++i) {
            c[i] = this.get(i) ? 49 : 48;
        }
        return new String(c);
    }

    public static byte[] extractRawDataArray(BitArray array) {
        return array.data;
    }

    public static BitArray construct(byte[] data, int size) {
        return new BitArray(data, size);
    }
}

