/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import com.milaboratory.util.CanReportProgress;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CountingInputStream
extends FilterInputStream {
    private long bytesRead;
    private volatile boolean closed = false;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r >= 0) {
            this.count(1L);
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r >= 0) {
            this.count(r);
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    protected final void count(long read) {
        if (read != -1L) {
            this.bytesRead += read;
        }
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public CanReportProgress getProgressReporter(final long totalSize) {
        return new CanReportProgress(){

            @Override
            public double getProgress() {
                return 1.0 * (double)CountingInputStream.this.bytesRead / (double)totalSize;
            }

            @Override
            public boolean isFinished() {
                return CountingInputStream.this.bytesRead == totalSize || CountingInputStream.this.closed;
            }
        };
    }
}

