/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import java.io.Serializable;
import java.util.Arrays;

public final class IntArrayList
implements Serializable {
    int[] data;
    int size = 0;

    public IntArrayList() {
        this.data = new int[10];
    }

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public IntArrayList(int ... data) {
        this.data = data;
        this.size = data.length;
    }

    private IntArrayList(int[] data, int size) {
        this.data = data;
        this.size = size;
    }

    public void clear() {
        this.size = 0;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public void add(int num) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = num;
    }

    public void add(int position, int num) {
        if (position < 0 || position >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, position, this.data, position + 1, this.size - position);
        this.data[position] = num;
        ++this.size;
    }

    public void addAll(int[] arr) {
        int arrLen = arr.length;
        this.ensureCapacity(arrLen + this.size);
        System.arraycopy(arr, 0, this.data, this.size, arrLen);
        this.size += arrLen;
    }

    public void addAll(IntArrayList intArrayList) {
        int arrLen = intArrayList.size();
        this.ensureCapacity(arrLen + this.size);
        System.arraycopy(intArrayList.data, 0, this.data, this.size, arrLen);
        this.size += arrLen;
    }

    public void set(int position, int num) {
        if (position < 0 || position >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[position] = num;
    }

    public void copyFrom(IntArrayList other) {
        this.clear();
        this.addAll(other);
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public void stableSort(IntComparator comparator) {
        for (int i = 1; i < this.size; ++i) {
            int key = this.data[i];
            for (int j = i; j > 0 && comparator.compare(this.data[j - 1], key) > 0; --j) {
                this.data[j] = this.data[j - 1];
            }
            this.data[j] = key;
        }
    }

    public void push(int value) {
        this.add(value);
    }

    public int peek() {
        return this.data[this.size - 1];
    }

    public int pop() {
        return this.data[--this.size];
    }

    public void add(int[] src, int fromIndex, int length) {
        this.ensureCapacity(this.size + length);
        System.arraycopy(src, fromIndex, this.data, this.size, length);
        this.size += length;
    }

    public void reverse() {
        this.reverse(0, this.size);
    }

    public void reverse(int from, int to) {
        int length = to - from;
        for (int i = (length + 1) / 2 - 1; i >= 0; --i) {
            int index1 = from + i;
            int tmp = this.data[index1];
            int index2 = from + length - i - 1;
            this.data[index1] = this.data[index2];
            this.data[index2] = tmp;
        }
    }

    public int get(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException("Size: " + this.size + " index: " + i);
        }
        return this.data[i];
    }

    public boolean replaceFirst(int from, int to) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != from) continue;
            this.data[i] = to;
            return true;
        }
        return false;
    }

    public boolean replaceAll(int from, int to) {
        boolean replaced = false;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != from) continue;
            this.data[i] = to;
            replaced = true;
        }
        return replaced;
    }

    public int last() {
        return this.data[this.size - 1];
    }

    public int[] toArray() {
        return Arrays.copyOfRange(this.data, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public boolean contains(int value) {
        return this.indexOf(value) >= 0;
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntArrayList clone() {
        return new IntArrayList(Arrays.copyOf(this.data, this.data.length), this.size);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntArrayList other = (IntArrayList)obj;
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        for (int i = 0; i < this.size; ++i) {
            hash = 31 * hash + this.data[i];
        }
        return hash;
    }

    public String toString() {
        int iMax = this.size() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.data[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static int[] getArrayReference(IntArrayList list) {
        return list.data;
    }

    public static interface IntComparator {
        public int compare(int var1, int var2);
    }
}

