/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import cc.redberry.pipe.OutputPort;

public final class IntCombinations
implements OutputPort<int[]> {
    final int[] combination;
    private final int n;
    private final int k;
    private boolean onFirst = true;

    public IntCombinations(int n, int k) {
        if (n < k) {
            throw new IllegalArgumentException(" n < k ");
        }
        this.n = n;
        this.k = k;
        this.combination = new int[k];
        this.reset();
    }

    public void reset() {
        this.onFirst = true;
        for (int i = 0; i < this.k; ++i) {
            this.combination[i] = i;
        }
    }

    private boolean isLast() {
        for (int i = 0; i < this.k; ++i) {
            if (this.combination[i] == i + this.n - this.k) continue;
            return false;
        }
        return true;
    }

    public int[] take() {
        if (this.onFirst) {
            this.onFirst = false;
        } else {
            int i;
            if (this.isLast()) {
                return null;
            }
            for (i = this.k - 1; i >= 0 && this.combination[i] == i + this.n - this.k; --i) {
            }
            int n = i++;
            int n2 = this.combination[n] + 1;
            this.combination[n] = n2;
            int m = n2;
            while (i < this.k) {
                this.combination[i] = ++m;
                ++i;
            }
        }
        return this.combination;
    }
}

