/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.core.sequence.NucleotideSequence;
import java.util.Arrays;

public class NSequenceWithQualityPrintHelper {
    final NSequenceWithQuality seq;
    final int offset;
    final int lineLength;
    final int linesCount;

    public NSequenceWithQualityPrintHelper(NSequenceWithQuality seq, int offset, int lineLength) {
        this.seq = seq;
        this.offset = offset;
        this.lineLength = lineLength;
        this.linesCount = (seq.size() + lineLength - 1) / lineLength;
    }

    public int getLinesCount() {
        return this.linesCount;
    }

    public String getSequenceLine(int lineIndex) {
        int initialPosition = lineIndex * this.lineLength;
        String initialPositionStr = "" + initialPosition;
        int numberOfspaces = this.offset - 1 - initialPositionStr.length();
        int finalPosition = Math.min(initialPosition + this.lineLength, this.seq.size());
        StringBuilder sb = new StringBuilder();
        sb.append(NSequenceWithQualityPrintHelper.spaces(numberOfspaces));
        sb.append(initialPositionStr);
        sb.append(" ");
        sb.append(((NucleotideSequence)this.seq.getSequence()).getRange(initialPosition, finalPosition));
        sb.append(" ");
        sb.append(finalPosition - 1);
        return sb.toString();
    }

    public String getQualityLine(int lineIndex) {
        int initialPosition = lineIndex * this.lineLength;
        int finalPosition = Math.min(initialPosition + this.lineLength, this.seq.size());
        StringBuilder sb = new StringBuilder();
        sb.append(NSequenceWithQualityPrintHelper.spaces(this.offset));
        sb.append(this.seq.getQuality().getRange(initialPosition, finalPosition));
        return sb.toString();
    }

    private static String spaces(int n) {
        char[] c = new char[n];
        Arrays.fill(c, ' ');
        return String.valueOf(c);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.linesCount; ++i) {
            sb.append(this.getSequenceLine(i));
            sb.append("\n");
            sb.append(this.getQualityLine(i));
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }
}

