/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import cc.redberry.pipe.OutputPort;
import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.primitivio.PrimitivO;
import com.milaboratory.primitivio.SerializersManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;

public interface ObjectSerializer<O> {
    public void write(Collection<O> var1, OutputStream var2);

    public OutputPort<O> read(InputStream var1);

    public static final class PrimitivIOObjectSerializer<O>
    implements ObjectSerializer<O> {
        private Class<O> clazz;
        private SerializersManager sm;

        public PrimitivIOObjectSerializer(Class<O> clazz) {
            this.clazz = clazz;
            this.sm = new SerializersManager();
        }

        @Override
        public void write(Collection<O> data, OutputStream stream) {
            PrimitivO o = new PrimitivO(new DataOutputStream(stream), this.sm);
            for (O datum : data) {
                o.writeObject(datum);
            }
        }

        @Override
        public OutputPort<O> read(InputStream stream) {
            final PrimitivI i = new PrimitivI(new DataInputStream(stream), this.sm);
            return new OutputPort<O>(){

                public O take() {
                    return i.readObject(PrimitivIOObjectSerializer.this.clazz);
                }
            };
        }
    }
}

