/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import com.milaboratory.util.IntArrayList;
import com.milaboratory.util.ParserException;
import gnu.trove.map.hash.TCharIntHashMap;

public final class ParseUtil {
    private ParseUtil() {
    }

    public static String[] splitWithBrackets(String string, char splitChar, String brackets) {
        return ParseUtil.splitWithBrackets(string, splitChar, new BracketsInfo(brackets));
    }

    public static String[] splitWithBrackets(String string, char splitChar, BracketsInfo brackets) {
        IntArrayList splitPoints = new IntArrayList();
        splitPoints.push(-1);
        BracketsProcessor bracketsProcessor = brackets.createBracketsProcessor();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bracketsProcessor.process(c) || c != splitChar || bracketsProcessor.getDepth() != 0) continue;
            splitPoints.push(i);
        }
        bracketsProcessor.finish();
        splitPoints.push(string.length());
        int size = splitPoints.size() - 1;
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = string.substring(splitPoints.get(i) + 1, splitPoints.get(i + 1));
        }
        return result;
    }

    private static final class BracketsProcessor {
        private final TCharIntHashMap bracketsMap;
        IntArrayList types = new IntArrayList();

        private BracketsProcessor(TCharIntHashMap bracketsMap) {
            this.bracketsMap = bracketsMap;
        }

        public boolean process(char c) {
            int v = this.bracketsMap.get(c);
            if (v == 0) {
                return false;
            }
            if (v < 0) {
                if (this.types.size() == 0) {
                    throw new ParserException("Closing bracket '" + c + "' before any opening bracket.");
                }
                if (this.types.pop() != -v) {
                    throw new ParserException("Unbalanced bracket '" + c + "'.");
                }
                return true;
            }
            this.types.push(v);
            return true;
        }

        public void finish() {
            if (this.getDepth() != 0) {
                throw new ParserException("Unbalanced brackets.");
            }
        }

        public int getDepth() {
            return this.types.size();
        }
    }

    public static final class BracketsInfo {
        private final TCharIntHashMap bracketsMap = new TCharIntHashMap();

        public BracketsInfo(String brackets) {
            if (brackets.length() % 2 != 0) {
                throw new IllegalArgumentException();
            }
            for (int i = brackets.length() / 2 - 1; i >= 0; --i) {
                this.bracketsMap.put(brackets.charAt(i * 2), i + 1);
                this.bracketsMap.put(brackets.charAt(i * 2 + 1), -i - 1);
            }
        }

        BracketsProcessor createBracketsProcessor() {
            return new BracketsProcessor(this.bracketsMap);
        }
    }
}

