/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import com.milaboratory.util.HashFunctions;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public final class RandomUtil {
    static final ThreadLocal<Randomm> threadLocalRandom = new ThreadLocal<Randomm>(){

        @Override
        protected Randomm initialValue() {
            long seed = seedCounter.addAndGet(353L);
            seed = HashFunctions.JenkinWang64shift(seed);
            return new Randomm(new Well19937c(seed));
        }
    };
    private static final AtomicLong seedCounter = new AtomicLong(641L);

    private RandomUtil() {
    }

    public static void setGlobalInitialSeed(long seed) {
        seedCounter.set(seed);
    }

    public static long reseedThreadLocal() {
        return RandomUtil.reseedThreadLocal(RandomUtil.getThreadLocalRandom().nextLong());
    }

    public static long reseedThreadLocal(long seed) {
        Well19937c random = RandomUtil.getThreadLocalRandom();
        random.setSeed(seed);
        return seed;
    }

    public static Well19937c getThreadLocalRandom() {
        return RandomUtil.threadLocalRandom.get().generator;
    }

    public static RandomDataGenerator getThreadLocalRandomData() {
        return RandomUtil.threadLocalRandom.get().rdi;
    }

    private static final class Randomm {
        final Well19937c generator;
        final RandomDataGenerator rdi;

        private Randomm(Well19937c generator) {
            this.generator = generator;
            this.rdi = new RandomDataGenerator((RandomGenerator)generator);
        }
    }
}

