/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.OutputPortCloseable;
import cc.redberry.pipe.blocks.Merger;
import cc.redberry.pipe.util.Chunk;
import cc.redberry.pipe.util.CountLimitingOutputPort;
import com.milaboratory.util.ObjectSerializer;
import gnu.trove.list.array.TLongArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.math3.random.RandomDataGenerator;

public class Randomizer<T> {
    private final OutputPort<T> initialSource;
    private final RandomDataGenerator random;
    private final int chunkSize;
    private final ObjectSerializer<T> serializer;
    private final File tempFile;
    private final TLongArrayList chunkOffsets = new TLongArrayList();
    private int lastChunkSize = -1;

    Randomizer(OutputPort<T> initialSource, RandomDataGenerator random, int chunkSize, ObjectSerializer<T> serializer, File tempFile) {
        this.initialSource = initialSource;
        this.random = random;
        this.chunkSize = chunkSize;
        this.serializer = serializer;
        this.tempFile = tempFile;
    }

    public static <T> OutputPortCloseable<T> randomize(OutputPort<T> initialSource, RandomDataGenerator random, int chunkSize, ObjectSerializer<T> serializer, File tempFile) throws IOException {
        Randomizer<T> sorter = new Randomizer<T>(initialSource, random, chunkSize, serializer, tempFile);
        sorter.build();
        return sorter.getRandomized();
    }

    void build() throws IOException {
        try (CountingOutputStream output = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.tempFile), 0x100000));){
            Chunk chunk;
            Merger chunked = CUtils.buffered((OutputPort)CUtils.chunked(this.initialSource, (int)this.chunkSize), (int)1);
            while ((chunk = (Chunk)chunked.take()) != null) {
                Object[] data = chunk.toArray();
                data = this.random.nextSample(Arrays.asList(data), data.length);
                this.chunkOffsets.add(output.getByteCount());
                this.serializer.write(Arrays.asList(data), (OutputStream)new CloseShieldOutputStream((OutputStream)output));
                this.lastChunkSize = data.length;
            }
        }
    }

    OutputPortCloseable<T> getRandomized() throws IOException {
        return new RandomizingPort();
    }

    private final class RandomizingPort
    implements OutputPortCloseable<T> {
        final List<OutputPortCloseable<T>> blocks = new ArrayList();
        private boolean closed = false;

        public RandomizingPort() throws IOException {
            for (int i = 0; i < Randomizer.this.chunkOffsets.size(); ++i) {
                FileInputStream fo = new FileInputStream(Randomizer.this.tempFile);
                fo.getChannel().position(Randomizer.this.chunkOffsets.get(i));
                CountLimitingOutputPort block = new CountLimitingOutputPort(Randomizer.this.serializer.read(new DataInputStream(new BufferedInputStream(fo, 16384))), i == Randomizer.this.chunkOffsets.size() - 1 ? (long)Randomizer.this.lastChunkSize : (long)Randomizer.this.chunkSize);
                this.blocks.add((OutputPortCloseable)block);
            }
        }

        public synchronized T take() {
            Object obj;
            while (true) {
                if (this.blocks.isEmpty()) {
                    this.close();
                    return null;
                }
                int id = this.blocks.size() == 1 ? 0 : Randomizer.this.random.nextInt(0, this.blocks.size() - 1);
                obj = this.blocks.get(id).take();
                if (obj != null) break;
                this.blocks.remove(id);
            }
            return obj;
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            for (OutputPortCloseable block : this.blocks) {
                block.close();
            }
            this.blocks.clear();
            Randomizer.this.tempFile.delete();
            this.closed = true;
        }
    }
}

