/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import com.milaboratory.core.Range;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class RangeMap<T>
implements Serializable {
    private final TreeMap<Range, T> map = new TreeMap(rangeComparator);
    private static final Comparator<Range> rangeComparator = new Comparator<Range>(){

        @Override
        public int compare(Range o1, Range o2) {
            int cmp = Integer.compare(o1.getLower(), o2.getLower());
            if (cmp != 0) {
                return cmp;
            }
            return 0;
        }
    };

    public Map.Entry<Range, T> findContaining(Range range) {
        Map.Entry<Range, T> ret = this.map.floorEntry(range);
        if (ret != null && ret.getKey().contains(range)) {
            return ret;
        }
        return null;
    }

    public void put(Range range, T value) {
        if (range.isReverse()) {
            throw new IllegalArgumentException("Don't support inverted ranges.");
        }
        if (range.isEmpty()) {
            throw new IllegalArgumentException("Don't support empty ranges.");
        }
        if (this.containIntersectingRanges(range)) {
            throw new IntersectingRangesException();
        }
        this.map.put(range, value);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Range enclosingRange() {
        return new Range(this.map.firstKey().getLower(), this.map.lastKey().getUpper());
    }

    public Set<Map.Entry<Range, T>> entrySet() {
        return this.map.entrySet();
    }

    public T remove(Range range) {
        return this.map.remove(range);
    }

    public List<Map.Entry<Range, T>> findAllIntersecting(Range range) {
        if (range.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Map.Entry<Range, T>> result = new ArrayList<Map.Entry<Range, T>>();
        Map.Entry<Range, T> tmp = this.map.floorEntry(range);
        if (tmp == null) {
            tmp = this.map.firstEntry();
        }
        while (tmp != null && tmp.getKey().getFrom() < range.getTo()) {
            if (tmp.getKey().intersectsWith(range)) {
                result.add(tmp);
            }
            tmp = this.map.higherEntry(tmp.getKey());
        }
        return result;
    }

    public List<Map.Entry<Range, T>> findAllIntersectingOrTouching(Range range) {
        ArrayList<Map.Entry<Range, T>> result = new ArrayList<Map.Entry<Range, T>>();
        Map.Entry<Range, T> tmp = this.map.floorEntry(range);
        if (tmp == null) {
            tmp = this.map.firstEntry();
        }
        while (tmp != null && tmp.getKey().getFrom() <= range.getTo()) {
            if (tmp.getKey().intersectsWithOrTouches(range)) {
                result.add(tmp);
            }
            tmp = this.map.higherEntry(tmp.getKey());
        }
        return result;
    }

    public boolean containIntersectingRanges(Range range) {
        Map.Entry<Range, T> tmp = this.map.floorEntry(range);
        if (tmp != null && tmp.getKey().intersectsWith(range)) {
            return true;
        }
        tmp = this.map.higherEntry(range);
        return tmp != null && tmp.getKey().intersectsWith(range);
    }

    public Map.Entry<Range, T> findSingleIntersection(Range range) {
        Map.Entry<Range, T> ret = null;
        Map.Entry<Range, T> tmp = this.map.floorEntry(range);
        if (tmp != null && tmp.getKey().intersectsWith(range)) {
            ret = tmp;
        }
        if ((tmp = this.map.higherEntry(range)) != null && tmp.getKey().intersectsWith(range)) {
            if (ret != null) {
                throw new IllegalArgumentException("Several intersection hits");
            }
            ret = tmp;
        }
        return ret;
    }

    public boolean isOverFragmented() {
        Range prev = null;
        for (Range range : this.map.navigableKeySet()) {
            if (prev == null) {
                prev = range;
                continue;
            }
            if (prev.getTo() != range.getFrom()) continue;
            return true;
        }
        return false;
    }

    public static final class IntersectingRangesException
    extends IllegalArgumentException {
        public IntersectingRangesException() {
        }

        public IntersectingRangesException(String message) {
            super(message);
        }
    }
}

