/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import cc.redberry.pipe.util.CountLimitingOutputPort;
import cc.redberry.pipe.util.CountingOutputPort;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.CanReportProgressAndStage;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class SmartProgressReporter
implements Runnable {
    private static final DecimalFormat percentFormat = new DecimalFormat("##.#'%'");
    private final PrintStream stream;
    private final CanReportProgressAndStage reporter;
    private double progressPeriod = 0.1;
    private double timePeriod = 120000.0;
    private boolean detectStageChange = true;

    public SmartProgressReporter(CanReportProgressAndStage reporter, PrintStream stream) {
        this.stream = stream;
        this.reporter = reporter;
    }

    public SmartProgressReporter(CanReportProgressAndStage reporter) {
        this(reporter, System.out);
    }

    public SmartProgressReporter(String prefix, CanReportProgress reporter) {
        this(prefix, reporter, System.out);
    }

    public SmartProgressReporter(final String prefix, final CanReportProgress reporter, PrintStream stream) {
        this.stream = stream;
        this.reporter = new CanReportProgressAndStage(){

            @Override
            public String getStage() {
                return prefix;
            }

            @Override
            public double getProgress() {
                return reporter.getProgress();
            }

            @Override
            public boolean isFinished() {
                return reporter.isFinished();
            }
        };
    }

    public double getProgressPeriod() {
        return this.progressPeriod;
    }

    public void setProgressPeriod(double progressPeriod) {
        this.progressPeriod = progressPeriod;
    }

    public double getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(double timePeriod) {
        this.timePeriod = timePeriod;
    }

    public boolean isDetectStageChange() {
        return this.detectStageChange;
    }

    public void setDetectStageChange(boolean detectStageChange) {
        this.detectStageChange = detectStageChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lastStamp = System.currentTimeMillis();
        double lastProgress = Double.NaN;
        String lastStage = null;
        try {
            while (!this.reporter.isFinished()) {
                String currentStage;
                double currentProgress;
                CanReportProgressAndStage canReportProgressAndStage = this.reporter;
                synchronized (canReportProgressAndStage) {
                    currentProgress = this.reporter.getProgress();
                    currentStage = this.reporter.getStage();
                }
                long currentStamp = System.currentTimeMillis();
                double deltaValue = currentProgress - lastProgress;
                long deltaTime = currentStamp - lastStamp;
                boolean trigger = false;
                if (this.detectStageChange && !currentStage.equals(lastStage)) {
                    trigger = true;
                }
                if (Double.isNaN(currentProgress) ^ Double.isNaN(lastProgress)) {
                    trigger = true;
                }
                if (deltaValue >= this.progressPeriod || (double)deltaTime >= this.timePeriod) {
                    trigger = true;
                }
                if (deltaValue < 0.0) {
                    deltaValue = Double.NaN;
                    trigger = true;
                }
                if (trigger) {
                    String etStr;
                    if (Double.isNaN(deltaValue) || deltaTime == 0L || deltaValue == 0.0) {
                        etStr = "";
                    } else {
                        long et = (long)((1.0 - currentProgress) * (double)deltaTime / deltaValue);
                        long hours = (et /= 1000L) / 3600L;
                        long minutes = (et -= hours * 3600L) / 60L;
                        long seconds = et -= minutes * 60L;
                        etStr = "  ETA: " + SmartProgressReporter.timeString(hours) + ":" + SmartProgressReporter.timeString(minutes) + ":" + SmartProgressReporter.timeString(seconds);
                    }
                    if (currentStage == null) {
                        currentStage = "null";
                    }
                    String sProgress = Double.isNaN(currentProgress) ? "progress unknown" : percentFormat.format(currentProgress * 100.0);
                    this.stream.println(currentStage + ": " + sProgress + etStr);
                    lastProgress = currentProgress;
                    lastStamp = currentStamp;
                    lastStage = currentStage;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String timeString(long time) {
        String timeStr = Long.toString(time);
        return timeStr.length() < 2 ? "0" + timeStr : timeStr;
    }

    public static void startProgressReport(SmartProgressReporter reporter) {
        Thread thread = new Thread(reporter);
        thread.setDaemon(true);
        thread.start();
    }

    public static void startProgressReport(CanReportProgressAndStage reporter, PrintStream stream) {
        SmartProgressReporter.startProgressReport(new SmartProgressReporter(reporter, stream));
    }

    public static void startProgressReport(CanReportProgressAndStage reporter) {
        SmartProgressReporter.startProgressReport(new SmartProgressReporter(reporter));
    }

    public static void startProgressReport(String prefix, CanReportProgress reporter) {
        SmartProgressReporter.startProgressReport(new SmartProgressReporter(prefix, reporter));
    }

    public static void startProgressReport(String prefix, CanReportProgress reporter, PrintStream stream) {
        SmartProgressReporter.startProgressReport(new SmartProgressReporter(prefix, reporter, stream));
    }

    public static CanReportProgress extractProgress(final CountingOutputPort<?> countingOutputPort, final long size) {
        return new CanReportProgress(){

            @Override
            public double getProgress() {
                return 1.0 * (double)countingOutputPort.getCount() / (double)size;
            }

            @Override
            public boolean isFinished() {
                return countingOutputPort.getCount() >= size;
            }
        };
    }

    public static CanReportProgress extractProgress(final CountLimitingOutputPort<?> countLimitingOutputPort) {
        return new CanReportProgress(){

            @Override
            public double getProgress() {
                long limit = countLimitingOutputPort.getLimit();
                long done = limit - countLimitingOutputPort.getElementsLeft();
                return 1.0 * (double)done / (double)limit;
            }

            @Override
            public boolean isFinished() {
                return countLimitingOutputPort.getElementsLeft() == 0L;
            }
        };
    }
}

