/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well44497b;

public class TempFileManager {
    private static volatile String prefix = "milib_";
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    static final ConcurrentHashMap<String, File> createdFiles = new ConcurrentHashMap();
    private static final RandomDataGenerator privateRandom = new RandomDataGenerator((RandomGenerator)new Well44497b());

    public static void setPrefix(String prefix) {
        TempFileManager.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void seed(long seed) {
        RandomDataGenerator randomDataGenerator = privateRandom;
        synchronized (randomDataGenerator) {
            privateRandom.getRandomGenerator().setSeed(seed);
        }
    }

    private static void ensureInitialized() {
        if (initialized.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new RemoveAction(), "DeleteTempFiles"));
            TempFileManager.seed(System.nanoTime() + 17L * new SecureRandom().nextLong());
        }
    }

    public static File getTempFile() {
        return TempFileManager.getTempFile(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempFile(Path tmpDir) {
        try {
            File file;
            String name;
            TempFileManager.ensureInitialized();
            do {
                RandomDataGenerator randomDataGenerator = privateRandom;
                synchronized (randomDataGenerator) {
                    name = prefix + privateRandom.nextHexString(40);
                }
            } while (createdFiles.putIfAbsent(name, file = tmpDir == null ? Files.createTempFile(name, null, new FileAttribute[0]).toFile() : Files.createTempFile(tmpDir, name, null, new FileAttribute[0]).toFile()) != null);
            if (file.length() != 0L) {
                throw new RuntimeException();
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempDir() {
        try {
            File dir;
            String name;
            TempFileManager.ensureInitialized();
            do {
                RandomDataGenerator randomDataGenerator = privateRandom;
                synchronized (randomDataGenerator) {
                    name = prefix + privateRandom.nextHexString(40);
                }
            } while (createdFiles.putIfAbsent(name, dir = Files.createTempDirectory(name, new FileAttribute[0]).toFile()) != null);
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class RemoveAction
    implements Runnable {
        private RemoveAction() {
        }

        @Override
        public void run() {
            for (File file : createdFiles.values()) {
                if (!file.exists()) continue;
                try {
                    if (Files.isDirectory(file.toPath(), new LinkOption[0])) {
                        FileUtils.deleteDirectory((File)file);
                        continue;
                    }
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

