/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.util;

import java.io.InputStream;
import java.util.Date;
import java.util.Properties;

public class VersionInfo {
    final String version;
    final String revision;
    final String name;
    final String branch;
    final String host;
    final Date timestamp;

    public VersionInfo(String version, String revision, String name, String branch, String host, Date timestamp) {
        this.version = version;
        this.revision = revision;
        this.name = name;
        this.branch = branch;
        this.host = host;
        this.timestamp = timestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getName() {
        return this.name;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getHost() {
        return this.host;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "VersionInfo{version='" + this.version + '\'' + ", revision='" + this.revision + '\'' + ", name='" + this.name + '\'' + ", branch='" + this.branch + '\'' + ", host='" + this.host + '\'' + ", timestamp=" + this.timestamp + '}';
    }

    public static VersionInfo getVersionInfoForArtifact(String artifactId) {
        return VersionInfo.getVersionInfo("/" + artifactId + "-build.properties");
    }

    static String longest(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1.length() > s2.length()) {
            return s1;
        }
        return s2;
    }

    static VersionInfo getVersionInfo(String resourceName) {
        Properties properties = new Properties();
        try (InputStream is = VersionInfo.class.getResourceAsStream(resourceName);){
            properties.load(is);
        }
        catch (Exception ex) {
            return null;
        }
        return new VersionInfo(properties.getProperty("version"), properties.getProperty("revision"), properties.getProperty("name"), properties.getProperty("branch"), properties.getProperty("host"), new Date(Long.parseLong(properties.getProperty("timestamp"))));
    }
}

