/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParameters;
import com.milaboratory.core.io.sequence.PairedRead;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.fastq.FastqRecordsReader;
import com.milaboratory.core.io.sequence.fastq.PairedFastqWriter;
import com.milaboratory.core.io.sequence.fastq.QualityFormat;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class CheckAction
implements Action {
    final AParameters params = new AParameters();

    public void go(ActionHelper helper) throws Exception {
        Pattern r1Pattern = this.params.getHeaderPatternR1();
        Pattern r2Pattern = this.params.getHeaderPatternR2();
        long missedR1 = 0L;
        long missedR2 = 0L;
        long skippedR1 = 0L;
        long skippedR2 = 0L;
        long mismatchedHeaders = 0L;
        long correct = 0L;
        try (FastqRecordsReader reader1 = new FastqRecordsReader(false, this.getInputStream(this.params.getInputR1()), 524288, false, true);
             FastqRecordsReader reader2 = new FastqRecordsReader(false, this.getInputStream(this.params.getInputR2()), 524288, false, true);
             PairedFastqWriter writer = this.params.doOutput() ? new PairedFastqWriter(this.params.getOutputR1(), this.params.getOutputR2()) : null;){
            block27: while (true) {
                boolean r1b = reader1.nextRecord(true);
                boolean r2b = reader2.nextRecord(true);
                if (!r1b && !r2b) {
                    break;
                }
                if (!r1b) {
                    ++missedR1;
                    continue;
                }
                if (!r2b) {
                    ++missedR2;
                    continue;
                }
                SingleRead r1 = reader1.createRead(0L, QualityFormat.Phred33);
                SingleRead r2 = reader2.createRead(0L, QualityFormat.Phred33);
                Matcher matcherR1 = r1Pattern.matcher(r1.getDescription());
                Matcher matcherR2 = r2Pattern.matcher(r2.getDescription());
                if (!matcherR1.matches()) {
                    ++skippedR1;
                    continue;
                }
                if (!matcherR2.matches()) {
                    ++skippedR2;
                    continue;
                }
                for (int i = 0; i < matcherR1.groupCount(); ++i) {
                    if (matcherR1.group(i + 1).equals(matcherR2.group(i + 1))) continue;
                    ++mismatchedHeaders;
                    continue block27;
                }
                ++correct;
                if (writer == null) continue;
                writer.write(new PairedRead(new SingleRead[]{r1, r2}));
            }
        }
        System.out.println("Missed R1: " + missedR1);
        System.out.println("Missed R2: " + missedR2);
        System.out.println("Skipped R1: " + skippedR1);
        System.out.println("Skipped R1: " + skippedR2);
        System.out.println("Mismatched header: " + mismatchedHeaders);
        System.out.println("Correct reads: " + correct);
    }

    public InputStream getInputStream(String fileName) throws IOException {
        if (fileName.endsWith(".gz")) {
            return new GZIPInputStream(new BufferedInputStream(new FileInputStream(fileName), 524288));
        }
        return new BufferedInputStream(new FileInputStream(fileName), 524288);
    }

    public String command() {
        return "check";
    }

    public ActionParameters params() {
        return this.params;
    }

    @Parameters(commandDescription="Checks paired-end read file for correctness and fixes it if possible.", optionPrefixes="-")
    public static final class AParameters
    extends ActionParameters {
        @Parameter(description="input_file_R1.fastq[.gz] input_file_R2.fastq[.gz] [fixed_output_file_R1.fastq[.gz] fixed_output_file_R2.fastq[.gz]]", variableArity=true)
        public List<String> parameters = new ArrayList<String>();
        @Parameter(description="Header pattern.", names={"-d", "--header-pattern"})
        String headerStructure = "^(.*)$";

        public Pattern getHeaderPatternR1() {
            return Pattern.compile(this.headerStructure);
        }

        public Pattern getHeaderPatternR2() {
            return Pattern.compile(this.headerStructure);
        }

        public boolean doOutput() {
            return this.parameters.size() == 4;
        }

        String getInputR1() {
            return this.parameters.get(0);
        }

        String getInputR2() {
            return this.parameters.get(1);
        }

        String getOutputR1() {
            return this.parameters.get(2);
        }

        String getOutputR2() {
            return this.parameters.get(3);
        }

        public void validate() {
            if (this.parameters.size() != 2 && this.parameters.size() != 4) {
                throw new ParameterException("Wrong number of parameters.");
            }
        }
    }
}

