/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.cli;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.Processor;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParameters;
import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.fastq.SingleFastqReader;
import com.milaboratory.core.io.sequence.fastq.SingleFastqWriter;
import com.milaboratory.mitools.cli.MiCLIUtil;
import com.milaboratory.mitools.processors.CutSide;
import com.milaboratory.mitools.processors.RandomCutter;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.SmartProgressReporter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class CutAction
implements Action {
    final AParams actionParameters = new AParams();

    public void go(ActionHelper helper) throws Exception {
        try (SingleFastqReader reader = MiCLIUtil.createSingleReader(this.actionParameters.getInput(), false);
             SingleFastqWriter writer = MiCLIUtil.createSingleWriter(this.actionParameters.getOutput());){
            SmartProgressReporter.startProgressReport((String)"Processing", (CanReportProgress)reader, (PrintStream)System.err);
            RandomCutter cutter = new RandomCutter(this.actionParameters.getPosition(), this.actionParameters.getMinLengt(), this.actionParameters.getMaxLengt(), this.actionParameters.getSeed());
            for (SingleRead read : CUtils.it((OutputPort)CUtils.wrap((OutputPort)reader, (Processor)cutter))) {
                writer.write((SequenceRead)read);
            }
        }
    }

    public String command() {
        return "cut";
    }

    public ActionParameters params() {
        return this.actionParameters;
    }

    @Parameters(commandDescription="Cut sequences.", optionPrefixes="-")
    public static final class AParams
    extends ActionParameters {
        @Parameter(description="[ input_file_R1.fastq[.gz] [ output_file.fastq[.gz] ] ]", variableArity=true)
        public List<String> parameters = new ArrayList<String>();
        @Parameter(description="Length.", names={"-l", "--length"})
        Integer length;
        @Parameter(description="Minimal length; inclusive (random value will be selected for each sequence; use with --max-length; don't use with --length option).", names={"-al", "--min-length"})
        Integer minLength;
        @Parameter(description="Maximal length; inclusive (random value will be selected for each sequence; use with --min-length; don't use with --length option).", names={"-bl", "--max-length"})
        Integer maxLength;
        @Parameter(description="Position to cut from. (possible values 'Left', 'Right', 'Random')", names={"-p", "--position"})
        String position = "Left";
        @Parameter(description="Seed for random generator.", names={"-s", "--seed"})
        Integer seed;

        public String getInput() {
            return this.parameters.size() == 0 ? "-" : this.parameters.get(0);
        }

        public String getOutput() {
            return this.parameters.size() < 2 ? "-" : this.parameters.get(1);
        }

        public int getSeed() {
            return this.seed == null ? 0 : this.seed;
        }

        public int getMinLengt() {
            if (this.length != null) {
                return this.length;
            }
            return this.minLength;
        }

        public int getMaxLengt() {
            if (this.length != null) {
                return this.length;
            }
            return this.maxLength;
        }

        public CutSide getPosition() {
            return CutSide.valueOf(this.position);
        }

        public void validate() {
            if (this.parameters.size() > 2) {
                throw new ParameterException("Wrong number of parameters.");
            }
            if (this.length == null && this.minLength == null && this.maxLength == null) {
                throw new ParameterException("Please specify the length to cut: --length or --max-length and --min-length.");
            }
            if (this.length != null && (this.minLength != null || this.maxLength != null)) {
                throw new ParameterException("--length option is not compatible with --max-length and --min-length");
            }
            if (this.minLength == null != (this.maxLength == null)) {
                throw new ParameterException("Please specify both options --max-length and --min-length.");
            }
        }
    }
}

