/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.cli;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.Processor;
import cc.redberry.pipe.blocks.Merger;
import cc.redberry.pipe.blocks.ParallelProcessor;
import cc.redberry.pipe.util.Indexer;
import cc.redberry.pipe.util.OrderedOutputPort;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParameters;
import com.milaboratory.core.PairedEndReadsLayout;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReadImpl;
import com.milaboratory.core.io.sequence.fastq.PairedFastqReader;
import com.milaboratory.core.io.sequence.fastq.SingleFastqWriter;
import com.milaboratory.core.merger.MismatchOnlyPairedReadMerger;
import com.milaboratory.core.merger.PairedReadMergingResult;
import com.milaboratory.core.merger.QualityMergingAlgorithm;
import com.milaboratory.mitools.cli.MiCLIUtil;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.SmartProgressReporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class MergeAction
implements Action {
    final MergingParameters actionParameters = new MergingParameters();

    public void go(ActionHelper helper) throws Exception {
        MismatchOnlyPairedReadMerger merger = new MismatchOnlyPairedReadMerger(this.actionParameters.overlap, this.actionParameters.similarity, this.actionParameters.maxQuality, this.actionParameters.getQualityMergingAlgorithm(), this.actionParameters.sameStrand ? PairedEndReadsLayout.Collinear : PairedEndReadsLayout.Opposite);
        long total = 0L;
        long overlapped = 0L;
        try (PairedFastqReader reader = new PairedFastqReader(this.actionParameters.getR1(), this.actionParameters.getR2());
             SingleFastqWriter mainWriter = MiCLIUtil.createSingleWriter(this.actionParameters.getOutput());
             SingleFastqWriter nfWriter = this.actionParameters.forwardNegative == null ? null : new SingleFastqWriter(this.actionParameters.forwardNegative);
             SingleFastqWriter nrWriter = this.actionParameters.reverseNegative == null ? null : new SingleFastqWriter(this.actionParameters.reverseNegative);){
            SmartProgressReporter.startProgressReport((String)"Merging", (CanReportProgress)reader, (PrintStream)System.err);
            Merger buffered = CUtils.buffered((OutputPort)reader, (int)256);
            ParallelProcessor processor = new ParallelProcessor((OutputPort)buffered, (Processor)merger, 1024, this.actionParameters.threads);
            OrderedOutputPort oop = new OrderedOutputPort((OutputPort)processor, (Indexer)new Indexer<PairedReadMergingResult>(){

                public long getIndex(PairedReadMergingResult pairedReadMergingResult) {
                    return pairedReadMergingResult.getOriginalRead().getId();
                }
            });
            boolean includeNonOverlapped = this.actionParameters.includeNonOverlapped;
            long id = 0L;
            for (PairedReadMergingResult result : CUtils.it((OutputPort)oop)) {
                ++total;
                if (result.isSuccessful()) {
                    mainWriter.write((SingleRead)new SingleReadImpl(result.getOriginalRead().getId(), result.getOverlappedSequence(), result.getOriginalRead().getR1().getDescription()));
                    ++overlapped;
                    continue;
                }
                if (nfWriter != null) {
                    nfWriter.write(result.getOriginalRead().getR1());
                }
                if (nrWriter != null) {
                    nrWriter.write(result.getOriginalRead().getR2());
                }
                if (!includeNonOverlapped) continue;
                mainWriter.write(result.getOriginalRead().getR1());
                mainWriter.write(result.getOriginalRead().getR2());
            }
        }
        if (this.actionParameters.report != null) {
            boolean n = !new File(this.actionParameters.report).exists();
            try (PrintStream reportStream = new PrintStream(new FileOutputStream(this.actionParameters.report, true));){
                if (n) {
                    reportStream.println("OutputFileName\tTotal\tOverlapped\tOverlappedPercent");
                }
                reportStream.println(this.actionParameters.getOutput() + "\t" + total + "\t" + overlapped + "\t" + 100.0 * (double)overlapped / (double)total);
            }
        }
    }

    public String command() {
        return "merge";
    }

    public ActionParameters params() {
        return this.actionParameters;
    }

    @Parameters(commandDescription="Merge overlapping paired-end reads.", optionPrefixes="-")
    public static final class MergingParameters
    extends ActionParameters {
        @Parameter(description="input_file_R1.fastq[.gz] input_file_R2.fastq[.gz] -|output_file.fastq[.gz]", variableArity=true)
        public List<String> parameters = new ArrayList<String>();
        @Parameter(description="FASTQ file to put non-overlapped forward reads (supported formats: *.fastq and *.fastq.gz).", names={"-nf", "--negative-forward"}, converter=MiCLIUtil.FileConverter.class)
        File forwardNegative;
        @Parameter(description="FASTQ file to put non-overlapped reverse reads (supported formats: *.fastq and *.fastq.gz).", names={"-nr", "--negative-reverse"}, converter=MiCLIUtil.FileConverter.class)
        File reverseNegative;
        @Parameter(description="Report file.", names={"-r", "--report"})
        String report;
        @Parameter(description="Include both paired-end reads for pairs where no overlap was found.", names={"-i", "--include-non-overlapped"})
        boolean includeNonOverlapped;
        @Parameter(description="Discard original sequence header and put sequential ids.", names={"-d", "--discard-header"})
        boolean discardHeader;
        @Parameter(description="Assume that reads are on the same strand (opposite of raw Illumina reads orientation).", names={"-ss", "--same-strand"})
        boolean sameStrand;
        @Parameter(description="Possible values: SumMax, SumSubtraction, MaxSubtraction, MaxMax. First word (match behaviour): Sum = sum quality values (result is limited by value of -m option); Max = maximal quality. Second word (mismatch behaviour): Max = take maximal score value, Subtraction = subtract minimal quality from maximal.", names={"-q", "--quality-merging-algorithm"})
        String qualityMergingAlgorithm = QualityMergingAlgorithm.MaxSubtraction.name();
        @Parameter(description="Minimal overlap.", names={"-p", "--overlap"}, validateWith=PositiveInteger.class)
        int overlap = 15;
        @Parameter(description="Minimal allowed similarity", names={"-s", "--similarity"})
        double similarity = 0.85;
        @Parameter(description="Maximal quality to set for letters within overlap.", names={"-m", "--max-quality"})
        int maxQuality = 50;
        @Parameter(description="Threads", names={"-t", "--threads"}, validateWith=PositiveInteger.class)
        int threads = Math.min(Runtime.getRuntime().availableProcessors(), 4);

        public String getR1() {
            return this.parameters.get(0);
        }

        public String getR2() {
            return this.parameters.get(1);
        }

        public String getOutput() {
            return this.parameters.size() == 2 ? "." : this.parameters.get(2);
        }

        public QualityMergingAlgorithm getQualityMergingAlgorithm() {
            return QualityMergingAlgorithm.getFromCLIName((String)this.qualityMergingAlgorithm);
        }

        public void validate() {
            if (this.parameters.size() > 3 || this.parameters.size() < 2) {
                throw new ParameterException("Wrong number of parameters.");
            }
        }
    }
}

