/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.cli;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParameters;
import com.milaboratory.cli.AllowNoArguments;
import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReadImpl;
import com.milaboratory.core.io.sequence.fastq.SingleFastqReader;
import com.milaboratory.core.io.sequence.fastq.SingleFastqWriter;
import com.milaboratory.mitools.cli.MiCLIUtil;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.SmartProgressReporter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@AllowNoArguments
public class RCAction
implements Action {
    final RCParameters actionParameters = new RCParameters();

    public void go(ActionHelper helper) throws Exception {
        try (SingleFastqReader reader = MiCLIUtil.createSingleReader(this.actionParameters.getInput(), false);
             SingleFastqWriter writer = MiCLIUtil.createSingleWriter(this.actionParameters.getOutput());){
            SmartProgressReporter.startProgressReport((String)"Processing", (CanReportProgress)reader, (PrintStream)System.err);
            for (SingleRead read : CUtils.it((OutputPort)reader)) {
                SingleReadImpl rc = new SingleReadImpl(read.getId(), read.getData().getReverseComplement(), read.getDescription());
                writer.write((SequenceRead)rc);
            }
        }
    }

    public String command() {
        return "rc";
    }

    public ActionParameters params() {
        return this.actionParameters;
    }

    @Parameters(commandDescription="Reverse complement.")
    public static final class RCParameters
    extends ActionParameters {
        @Parameter(description="[ input_file_R1.fastq[.gz] [ output_file.fastq[.gz] ] ]", variableArity=true)
        public List<String> parameters = new ArrayList<String>();

        public String getInput() {
            return this.parameters.size() == 0 ? "." : this.parameters.get(0);
        }

        public String getOutput() {
            return this.parameters.size() < 2 ? "." : this.parameters.get(1);
        }

        public void validate() {
            if (this.parameters.size() > 2) {
                throw new ParameterException("Wrong number of parameters.");
            }
        }
    }
}

