/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.cli;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.util.CountLimitingOutputPort;
import cc.redberry.pipe.util.CountingOutputPort;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParameters;
import com.milaboratory.cli.ActionParametersWithOutput;
import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SequenceReaderCloseable;
import com.milaboratory.core.io.sequence.SequenceWriter;
import com.milaboratory.core.io.sequence.fastq.PairedFastqReader;
import com.milaboratory.core.io.sequence.fastq.PairedFastqWriter;
import com.milaboratory.core.io.sequence.fastq.SingleFastqReader;
import com.milaboratory.core.io.sequence.fastq.SingleFastqWriter;
import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.primitivio.PrimitivO;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.ObjectSerializer;
import com.milaboratory.util.Randomizer;
import com.milaboratory.util.SmartProgressReporter;
import com.milaboratory.util.TempFileManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public class RandomizeAction
implements Action {
    final AParameters parameters = new AParameters();

    public void go(ActionHelper helper) throws Exception {
        long totalReadsCount;
        CountingOutputPort randomized;
        Path tmp = this.parameters.getTmpPath();
        boolean tmpExisted = true;
        try (SequenceReaderCloseable<SequenceRead> reader = this.parameters.getReader();){
            if (tmp != null && !Files.isDirectory(tmp, new LinkOption[0])) {
                tmpExisted = false;
                Files.createDirectory(tmp, new FileAttribute[0]);
            }
            SmartProgressReporter.startProgressReport((String)"Randomizing chunks", (CanReportProgress)((CanReportProgress)reader));
            CountingOutputPort countingReader = new CountingOutputPort(reader);
            File tempFile = tmp == null ? TempFileManager.getTempFile() : TempFileManager.getTempFile((Path)tmp);
            randomized = new CountingOutputPort((OutputPort)Randomizer.randomize((OutputPort)countingReader, (RandomDataGenerator)new RandomDataGenerator((RandomGenerator)new Well19937c(this.parameters.getSeed())), (int)this.parameters.chunkSize, (ObjectSerializer)new ObjectSerializer<SequenceRead>(){

                public void write(Collection<SequenceRead> data, OutputStream stream) {
                    try (PrimitivO o = new PrimitivO((OutputStream)new BufferedOutputStream(stream));){
                        o.writeInt(data.size());
                        for (SequenceRead el : data) {
                            o.writeObject((Object)el);
                        }
                    }
                }

                public OutputPort<SequenceRead> read(InputStream stream) {
                    final PrimitivI i = new PrimitivI(stream);
                    int count = i.readInt();
                    return new CountLimitingOutputPort((OutputPort)new OutputPort<SequenceRead>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public SequenceRead take() {
                            PrimitivI primitivI = i;
                            synchronized (primitivI) {
                                return (SequenceRead)i.readObject(SequenceRead.class);
                            }
                        }
                    }, (long)count);
                }
            }, (File)tempFile));
            totalReadsCount = countingReader.getCount();
        }
        SmartProgressReporter.startProgressReport((String)"Writing result", (CanReportProgress)SmartProgressReporter.extractProgress((CountingOutputPort)randomized, (long)totalReadsCount));
        var8_5 = null;
        try (SequenceWriter<SequenceRead> writer = this.parameters.getWriter();){
            for (SequenceRead read : CUtils.it((OutputPort)randomized)) {
                writer.write(read);
            }
        }
        catch (Throwable throwable) {
            var8_5 = throwable;
            throw throwable;
        }
    }

    public String command() {
        return "randomize";
    }

    public ActionParameters params() {
        return this.parameters;
    }

    @Parameters(commandDescription="Randomize reads in single-end or paired-end fastq files.")
    public static final class AParameters
    extends ActionParametersWithOutput {
        @Parameter(description="input_file_R1.fastq[.gz] [input_file_R2.fastq[.gz]] output_file_R1.fastq[.gz] [output_file_R2.fastq[.gz]]", variableArity=true)
        public List<String> parameters = new ArrayList<String>();
        @Parameter(description="Random generator seed (0 to use current time as random seed).", names={"-s", "--seed"})
        public Long seed;
        @Parameter(description="Chunk size in number of reads. Consumed memory is proportional to this number.", names={"-c", "--chunk"})
        public int chunkSize = 500000;
        @Parameter(description="Path to temp directory", names={"--tmp-dir"})
        public String tmpDir;

        public long getSeed() {
            if (this.seed == null) {
                return System.nanoTime();
            }
            return this.seed;
        }

        public SequenceReaderCloseable<SequenceRead> getReader() throws IOException {
            if (this.parameters.size() == 2) {
                return new SingleFastqReader(this.parameters.get(0));
            }
            return new PairedFastqReader(this.parameters.get(0), this.parameters.get(1));
        }

        public SequenceWriter<SequenceRead> getWriter() throws IOException {
            if (this.parameters.size() == 2) {
                return new SingleFastqWriter(this.parameters.get(1));
            }
            return new PairedFastqWriter(this.parameters.get(2), this.parameters.get(3));
        }

        protected List<String> getOutputFiles() {
            if (this.parameters.size() == 2) {
                return this.parameters.subList(1, 2);
            }
            return this.parameters.subList(2, 4);
        }

        private Path getTmpPath() {
            if (this.tmpDir == null) {
                return null;
            }
            return Paths.get(this.tmpDir, new String[0]);
        }

        public void validate() {
            if (this.parameters.size() != 2 && this.parameters.size() != 4) {
                throw new ParameterException("Wrong number of parameters.");
            }
        }
    }
}

