/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.cli;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParameters;
import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReadImpl;
import com.milaboratory.core.io.sequence.fastq.SingleFastqReader;
import com.milaboratory.core.io.sequence.fastq.SingleFastqWriter;
import com.milaboratory.mitools.cli.MiCLIUtil;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.SmartProgressReporter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RenameAction
implements Action {
    final RenameParameters actionParameters = new RenameParameters();

    public void go(ActionHelper helper) throws Exception {
        String newName = this.actionParameters.name;
        Pattern pattern = this.actionParameters.pattern == null ? null : Pattern.compile(this.actionParameters.pattern);
        try (SingleFastqReader reader = MiCLIUtil.createSingleReader(this.actionParameters.getInput(), false);
             SingleFastqWriter writer = MiCLIUtil.createSingleWriter(this.actionParameters.getOutput());){
            SmartProgressReporter.startProgressReport((String)"Processing", (CanReportProgress)reader, (PrintStream)System.err);
            for (SingleRead read : CUtils.it((OutputPort)reader)) {
                Matcher matcher;
                String description = newName.replace("%n", Long.toString(read.getId()));
                description = description.replace("%o", read.getDescription());
                if (pattern != null && (matcher = pattern.matcher(read.getDescription())).find()) {
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        description = description.replace("%g" + i, matcher.group(i));
                    }
                }
                SingleReadImpl rc = new SingleReadImpl(read.getId(), read.getData(), description);
                writer.write((SequenceRead)rc);
            }
        }
    }

    public String command() {
        return "rename";
    }

    public ActionParameters params() {
        return this.actionParameters;
    }

    @Parameters(commandDescription="Relabel sequences (change sequence headers).")
    public static final class RenameParameters
    extends ActionParameters {
        @Parameter(description="[ input_file_R1.fastq[.gz] [ output_file.fastq[.gz] ] ]", variableArity=true)
        public List<String> parameters = new ArrayList<String>();
        @Parameter(description="New header (%n - for index; %o - for old description; %g1, %g2, ... - for old description)", names={"-p", "--pattern"})
        String pattern;
        @Parameter(description="New name (%n - for index; %o - for old description; %g1, %g2, ... - extracted regexp groups, if -p option used), example: -n \"R%n %o\" to add read index to header", names={"-n", "--name"})
        String name;

        public String getInput() {
            return this.parameters.size() == 0 ? "." : this.parameters.get(0);
        }

        public String getOutput() {
            return this.parameters.size() < 2 ? "." : this.parameters.get(1);
        }

        public void validate() {
            if (this.parameters.size() > 2) {
                throw new ParameterException("Wrong number of parameters.");
            }
        }
    }
}

