/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParameters;
import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SequenceReaderCloseable;
import com.milaboratory.core.io.sequence.SequenceWriter;
import com.milaboratory.core.io.sequence.fastq.PairedFastqReader;
import com.milaboratory.core.io.sequence.fastq.PairedFastqWriter;
import com.milaboratory.core.io.sequence.fastq.SingleFastqReader;
import com.milaboratory.core.io.sequence.fastq.SingleFastqWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public class SplitAction
implements Action {
    final AParameters params = new AParameters();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void go(ActionHelper helper) throws Exception {
        Well19937c gen = new Well19937c();
        int partId = 0;
        try (SequenceReaderCloseable<?> sequenceReader = this.getSequenceReader();){
            SequenceRead read = (SequenceRead)sequenceReader.take();
            block23: while (true) {
                int chunkSize = this.generateSize((RandomGenerator)gen, this.params.getMinChunkSize(), this.params.getMaxChunkSize());
                if (read == null) {
                    return;
                }
                SequenceWriter<?> writer = this.getSequenceWriter(partId++);
                Throwable throwable = null;
                try {
                    do {
                        if (chunkSize-- <= 0) continue block23;
                        if (read == null) return;
                        writer.write(read);
                    } while ((read = (SequenceRead)sequenceReader.take()) != null);
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    writer.close();
                    continue;
                }
                break;
            }
        }
    }

    public String command() {
        return "split";
    }

    public ActionParameters params() {
        return this.params;
    }

    public int generateSize(RandomGenerator generator, int min, int max) {
        if (min == max) {
            return min;
        }
        return generator.nextInt(max - min + 1) + min;
    }

    public SequenceWriter<?> getSequenceWriter(int partId) throws IOException {
        if (this.params.numberOfReads() == 1) {
            return new SingleFastqWriter(this.getOutputFileName(1, partId));
        }
        if (this.params.numberOfReads() == 2) {
            return new PairedFastqWriter(this.getOutputFileName(1, partId), this.getOutputFileName(2, partId));
        }
        throw new RuntimeException();
    }

    public String getOutputFileName(int readId, int partId) {
        return this.params.getOutputFileNamePattern().replace("{P}", this.partIndexToString(partId)).replace("{R}", Integer.toString(readId));
    }

    public String partIndexToString(int val) {
        String s = Integer.toString(val);
        int zeroLength = this.params.partIndexDigits - s.length();
        if (zeroLength < 0) {
            return s;
        }
        char[] c = new char[zeroLength];
        Arrays.fill(c, '0');
        return new String(c) + s;
    }

    public SequenceReaderCloseable<?> getSequenceReader() throws IOException {
        if (this.params.numberOfReads() == 1) {
            return new SingleFastqReader(this.params.parameters.get(0));
        }
        if (this.params.numberOfReads() == 2) {
            return new PairedFastqReader(this.params.parameters.get(0), this.params.parameters.get(1));
        }
        throw new RuntimeException();
    }

    @Parameters(commandDescription="Splits input fastq file(s) into several parts. \"{P}\" in output file name will be substituted with sequential part index, \"{R}\" will be substituted with read index (in case of one input file will always be substituted with \"1\").")
    public static final class AParameters
    extends ActionParameters {
        @Parameter(description="input_file_R1.fastq[.gz] [ input_file_R2.fastq[.gz] ] output_file_part{P}_R{R}.fastq[.gz]", variableArity=true)
        public List<String> parameters = new ArrayList<String>();
        @Parameter(description="Minimal chunk size (use with --max-chunk-size option for random-sized chunks).", names={"-l", "--min-chunk-size"})
        Integer minChunkSize;
        @Parameter(description="Maximal chunk size (use with --min-chunk-size option for random-sized chunks).", names={"-u", "--max-chunk-size"})
        Integer maxChunkSize;
        @Parameter(description="Chunk size (use for fixed size chunks).", names={"-c", "--chunk-size"})
        Integer chunkSize;
        @Parameter(description="Part index digits.", names={"-d", "--part-digits"})
        int partIndexDigits = 4;

        boolean randomSizedChunks() {
            return this.chunkSize == null;
        }

        int getMinChunkSize() {
            if (this.randomSizedChunks()) {
                return this.minChunkSize;
            }
            return this.chunkSize;
        }

        int getMaxChunkSize() {
            if (this.randomSizedChunks()) {
                return this.maxChunkSize;
            }
            return this.chunkSize;
        }

        int numberOfReads() {
            return this.parameters.size() - 1;
        }

        String getOutputFileNamePattern() {
            return this.parameters.get(this.parameters.size() - 1);
        }

        public void validate() {
            String ofp;
            if (this.parameters.size() > 3 || this.parameters.size() < 2) {
                throw new ParameterException("Wrong number of parameters.");
            }
            if (this.chunkSize == null && this.minChunkSize == null && this.maxChunkSize == null) {
                throw new ParameterException("Please specify chunk size.");
            }
            if (this.chunkSize != null) {
                if (this.minChunkSize != null) {
                    throw new ParameterException("--min-chunk-size is not compatible with --chunk-size.");
                }
                if (this.maxChunkSize != null) {
                    throw new ParameterException("--max-chunk-size is not compatible with --chunk-size.");
                }
            } else {
                if (this.minChunkSize == null) {
                    throw new ParameterException("Please specify value for --min-chunk-size.");
                }
                if (this.maxChunkSize == null) {
                    throw new ParameterException("Please specify value for --max-chunk-size.");
                }
            }
            if (!(ofp = this.getOutputFileNamePattern()).contains("{P}")) {
                throw new ParameterException("Output file name doesn't contain \"{P}\".");
            }
            if (this.numberOfReads() == 2 && !ofp.contains("{R}")) {
                throw new ParameterException("Output file name doesn't contain \"{R}\" while paired-end input is used.");
            }
        }
    }
}

