/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.cli;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.Processor;
import cc.redberry.pipe.blocks.FilteringPort;
import cc.redberry.pipe.blocks.Merger;
import cc.redberry.pipe.blocks.ParallelProcessor;
import cc.redberry.primitives.Filter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParameters;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.fastq.SingleFastqReader;
import com.milaboratory.core.io.sequence.fastq.SingleFastqWriter;
import com.milaboratory.mitools.cli.MiCLIUtil;
import com.milaboratory.mitools.cli.SimpleReadsStatisticsPortWrapper;
import com.milaboratory.mitools.trimmer.ReadLengthFilter;
import com.milaboratory.mitools.trimmer.SequenceTrimmer;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.SmartProgressReporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class TrimAction
implements Action {
    final TrimParameters actionParameters = new TrimParameters();

    public void go(ActionHelper helper) throws Exception {
        block38: {
            try (SingleFastqReader reader = MiCLIUtil.createSingleReader(this.actionParameters.getInput(), false);
                 SingleFastqWriter writer = MiCLIUtil.createSingleWriter(this.actionParameters.getOutput());){
                SmartProgressReporter.startProgressReport((String)"Trimming", (CanReportProgress)reader, (PrintStream)System.err);
                SimpleReadsStatisticsPortWrapper stats = new SimpleReadsStatisticsPortWrapper(reader);
                Merger buffered = CUtils.buffered(stats, (int)256);
                SequenceTrimmer trimmer = new SequenceTrimmer(this.actionParameters.qualityThreshold, this.actionParameters.trimLeft(), this.actionParameters.trimRight());
                ParallelProcessor processor = new ParallelProcessor((OutputPort)buffered, (Processor)trimmer, 1024, this.actionParameters.threads);
                FilteringPort filtered = new FilteringPort((OutputPort)processor, (Filter)new ReadLengthFilter(this.actionParameters.length));
                for (SingleRead result : CUtils.it((OutputPort)filtered)) {
                    writer.write(result);
                }
                if (this.actionParameters.report == null) break block38;
                boolean n = !new File(this.actionParameters.report).exists();
                try (PrintStream reportStream = new PrintStream(new FileOutputStream(this.actionParameters.report, true));){
                    if (n) {
                        reportStream.println("OutputFileName\tTotal\tTrimmed\tPercentOfReads\tPercentOfNucleotides\tPercentFiltered");
                    }
                    reportStream.println(this.actionParameters.getOutput() + "\t" + stats.count.get() + "\t" + trimmer.getTotalTrimmedReads() + "\t" + 100.0 * (double)trimmer.getTotalTrimmedReads() / (double)stats.count.get() + "\t" + 100.0 * (double)(trimmer.getTrimmedNucleotidesLeft() + trimmer.getTrimmedNucleotidesRight()) / (double)stats.nucleotides.get() + "\t" + 100.0 * (double)filtered.getRejectedCount() / (double)stats.count.get());
                }
            }
        }
    }

    public String command() {
        return "trim";
    }

    public ActionParameters params() {
        return this.actionParameters;
    }

    @Parameters(commandDescription="Trim low quality ends of reads.")
    private static final class TrimParameters
    extends ActionParameters {
        @Parameter(description="input_file.fastq[.gz] -|output_file.fastq[.gz]", variableArity=true)
        public List<String> parameters = new ArrayList<String>();
        @Parameter(description="Trim from left side", names={"-tl", "--left"})
        public Boolean left;
        @Parameter(description="Trim from right side", names={"-tr", "--right"})
        public Boolean right;
        @Parameter(description="Quality threshold", names={"-q", "--quality"}, validateWith=PositiveInteger.class)
        public int qualityThreshold = 15;
        @Parameter(description="Length threshold", names={"-l", "--length"})
        public int length = 10;
        @Parameter(description="Threads", names={"-t", "--threads"}, validateWith=PositiveInteger.class)
        int threads = Math.min(Runtime.getRuntime().availableProcessors(), 6);
        @Parameter(description="Report file.", names={"-r", "--report"})
        String report;

        private TrimParameters() {
        }

        public String getInput() {
            return this.parameters.get(0);
        }

        public String getOutput() {
            return this.parameters.get(1);
        }

        public boolean trimLeft() {
            return this.left == null ? false : this.left;
        }

        public boolean trimRight() {
            return this.right == null ? false : this.right;
        }

        public void validate() {
            if (this.parameters.size() != 2) {
                throw new ParameterException("Wrong number of parameters.");
            }
        }
    }
}

