/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.processors;

import cc.redberry.pipe.Processor;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReadImpl;
import com.milaboratory.mitools.processors.CutSide;
import com.milaboratory.util.RandomUtil;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.random.Well44497b;

public final class RandomCutter
implements Processor<SingleRead, SingleRead> {
    private final CutSide side;
    private final int minLength;
    private final int maxLength;
    private final long seed;

    public RandomCutter(CutSide side, int minLength, int maxLength) {
        this(side, minLength, maxLength, 0L);
    }

    public RandomCutter(CutSide side, int minLength, int maxLength, long seed) {
        if (side == null) {
            throw new NullPointerException();
        }
        this.side = side;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.seed = seed;
    }

    public SingleRead process(SingleRead input) {
        int startPosition;
        Well19937c rnd;
        if (this.seed == 0L) {
            rnd = RandomUtil.getThreadLocalRandom();
        } else {
            Well44497b w = new Well44497b(this.seed);
            w.setSeed(5147L * w.nextLong() + 7549L * input.getId());
            rnd = w;
        }
        int length = this.minLength == this.maxLength ? this.minLength : this.minLength + rnd.nextInt(this.maxLength - this.minLength + 1);
        if (length > input.getData().size()) {
            length = input.getData().size();
        }
        switch (this.side) {
            case Left: {
                startPosition = 0;
                break;
            }
            case Right: {
                startPosition = input.getData().size() - length;
                break;
            }
            case Random: {
                startPosition = length == input.getData().size() ? 0 : rnd.nextInt(input.getData().size() - length + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new SingleReadImpl(input.getId(), input.getData().getRange(startPosition, startPosition + length), input.getDescription());
    }
}

