/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.mitools.trimmer;

import cc.redberry.pipe.Processor;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReadImpl;
import com.milaboratory.core.sequence.SequenceQuality;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public final class SequenceTrimmer
implements Processor<SingleRead, SingleRead>,
Serializable {
    final int qualityToTrimm;
    final boolean trimmLeft;
    final boolean trimmRight;
    final AtomicLong trimmedNucleotidesLeft = new AtomicLong();
    final AtomicLong trimmedReadsLeft = new AtomicLong();
    final AtomicLong trimmedNucleotidesRight = new AtomicLong();
    final AtomicLong trimmedReadsRight = new AtomicLong();
    final AtomicLong totalTrimmedReads = new AtomicLong();

    public SequenceTrimmer(int qualityToTrimm, boolean trimmLeft, boolean trimmRight) {
        this.qualityToTrimm = qualityToTrimm;
        this.trimmLeft = trimmLeft;
        this.trimmRight = trimmRight;
    }

    public long getTrimmedNucleotidesLeft() {
        return this.trimmedNucleotidesLeft.get();
    }

    public long getTrimmedReadsLeft() {
        return this.trimmedReadsLeft.get();
    }

    public long getTrimmedNucleotidesRight() {
        return this.trimmedNucleotidesRight.get();
    }

    public long getTrimmedReadsRight() {
        return this.trimmedReadsRight.get();
    }

    public long getTotalTrimmedReads() {
        return this.totalTrimmedReads.get();
    }

    public SingleRead process(SingleRead input) {
        int trimmedRight;
        int i;
        SequenceQuality quality = input.getData().getQuality();
        int begin = 0;
        if (this.trimmLeft) {
            for (i = 0; i < quality.size(); ++i) {
                if (quality.value(i) <= this.qualityToTrimm) continue;
                begin = i;
                break;
            }
        }
        int end = quality.size();
        if (this.trimmRight) {
            for (i = quality.size() - 1; i >= 0; --i) {
                if (quality.value(i) <= this.qualityToTrimm) continue;
                end = i + 1;
                break;
            }
        }
        if (end < begin) {
            begin = end = (end + begin) / 2;
        }
        if (begin != 0) {
            this.trimmedReadsLeft.incrementAndGet();
            this.trimmedNucleotidesLeft.addAndGet(begin);
        }
        if ((trimmedRight = quality.size() - end) != 0) {
            this.trimmedReadsRight.incrementAndGet();
            this.trimmedNucleotidesRight.addAndGet(trimmedRight);
        }
        if (begin == 0 && trimmedRight == 0) {
            return input;
        }
        this.totalTrimmedReads.incrementAndGet();
        return new SingleReadImpl(input.getId(), input.getData().getRange(begin, end), input.getDescription());
    }
}

