/*
 * Decompiled with CFR 0.152.
 */
package com.mindee;

import com.mindee.DocumentToParse;
import com.mindee.MindeeClient;
import com.mindee.MindeeClientInit;
import com.mindee.parsing.CustomEndpoint;
import com.mindee.parsing.PageOptions;
import com.mindee.parsing.PageOptionsOperation;
import com.mindee.parsing.common.Document;
import com.mindee.parsing.common.Inference;
import com.mindee.parsing.custom.CustomV1Inference;
import com.mindee.parsing.invoice.InvoiceV4Inference;
import com.mindee.parsing.passport.PassportV1Inference;
import com.mindee.parsing.receipt.ReceiptV4Inference;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import picocli.CommandLine;

@CommandLine.Command(name="CLI", scope=CommandLine.ScopeType.INHERIT, subcommands={CommandLine.HelpCommand.class}, description={"Invoke Off The Shelf API for invoice, receipt, and passports"})
public class CommandLineInterface {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-w", "--words"}, scope=CommandLine.ScopeType.INHERIT, paramLabel="WORDS", description={"Include words in response"})
    private boolean words;
    @CommandLine.Option(names={"-o", "--output-type"}, scope=CommandLine.ScopeType.INHERIT, paramLabel="OUTPUT_TYPE", description={"Output type, one of:\n  summary - document level predictions\n  full - all parsed data"})
    private OutputChoices outputType;
    @CommandLine.Option(names={"-k", "--api-key"}, scope=CommandLine.ScopeType.INHERIT, paramLabel="MINDEE_API_KEY", description={"API key, if not set, will use system property"})
    private String apiKey;
    @CommandLine.Option(names={"-c", "--cut-doc"}, scope=CommandLine.ScopeType.INHERIT, paramLabel="<CutDoc>", description={"Keep only the first 5 pages of the document"})
    private boolean cutDoc;

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new CommandLineInterface()).execute(args);
        System.exit(exitCode);
    }

    @CommandLine.Command(name="invoice", description={"Invokes the invoice API"})
    void invoiceMethod(@CommandLine.Parameters(index="0", paramLabel="<path>", scope=CommandLine.ScopeType.LOCAL) File file) throws IOException {
        System.out.println(this.standardProductOutput(InvoiceV4Inference.class, file));
    }

    @CommandLine.Command(name="receipt", description={"Invokes the receipt API"})
    void receiptMethod(@CommandLine.Parameters(index="0", paramLabel="<path>", scope=CommandLine.ScopeType.LOCAL) File file) throws IOException {
        System.out.println(this.standardProductOutput(ReceiptV4Inference.class, file));
    }

    @CommandLine.Command(name="passport", description={"Invokes the passport API"})
    void passportMethod(@CommandLine.Parameters(index="0", paramLabel="<path>", scope=CommandLine.ScopeType.LOCAL) File file) throws IOException {
        System.out.println(this.standardProductOutput(PassportV1Inference.class, file));
    }

    @CommandLine.Command(name="custom", description={"Invokes a builder API"})
    void customMethod(@CommandLine.Option(names={"-a", "--account"}, scope=CommandLine.ScopeType.LOCAL, required=true, paramLabel="accountName", description={"The name of the account"}) String accountName, @CommandLine.Parameters(index="0", scope=CommandLine.ScopeType.LOCAL, paramLabel="<productName>") String productName, @CommandLine.Parameters(index="1", scope=CommandLine.ScopeType.LOCAL, paramLabel="<path>") File file) throws IOException {
        MindeeClient mindeeClient = MindeeClientInit.create(this.apiKey);
        CustomEndpoint customEndpoint = new CustomEndpoint(productName, accountName, "1");
        Document<CustomV1Inference> document = this.cutDoc ? mindeeClient.parse(new DocumentToParse(file), customEndpoint, this.getDefaultPageOptions()) : mindeeClient.parse(new DocumentToParse(file), customEndpoint);
        System.out.println(document.toString());
    }

    protected PageOptions getDefaultPageOptions() {
        ArrayList<Integer> pageNumbers = new ArrayList<Integer>();
        pageNumbers.add(0);
        pageNumbers.add(1);
        pageNumbers.add(2);
        pageNumbers.add(3);
        pageNumbers.add(4);
        return new PageOptions(pageNumbers, PageOptionsOperation.KEEP_ONLY_LISTED_PAGES);
    }

    private <T extends Inference<?, ?>> String standardProductOutput(Class<T> docClass, File file) throws IOException {
        MindeeClient mindeeClient = MindeeClientInit.create(this.apiKey);
        DocumentToParse input = new DocumentToParse(file);
        Document<T> response = this.cutDoc ? mindeeClient.parse(docClass, input, this.words, this.getDefaultPageOptions()) : mindeeClient.parse(docClass, input, this.words);
        if (this.outputType == OutputChoices.full) {
            return response.toString();
        }
        return ((Inference)response.getInference()).getDocumentPrediction().toString();
    }

    private static enum OutputChoices {
        summary,
        full;

    }
}

