/*
 * Decompiled with CFR 0.152.
 */
package com.mindee;

import java.util.Optional;

public class MindeeSettings {
    private static final String DEFAULT_MINDEE_API_URL = "https://api.mindee.net/v1";
    private final String apiKey;
    private final String baseUrl;

    public MindeeSettings() {
        this("", "");
    }

    public Optional<String> getApiKey() {
        return Optional.ofNullable(this.apiKey);
    }

    public MindeeSettings(String apiKey) {
        this(apiKey, "");
    }

    public MindeeSettings(String apiKey, String baseUrl) {
        String baseUrlFromEnv;
        String apiKeyFromEnv;
        this.apiKey = apiKey == null || apiKey.trim().isEmpty() ? ((apiKeyFromEnv = System.getenv("MINDEE_API_KEY")) == null || apiKeyFromEnv.trim().isEmpty() ? null : apiKeyFromEnv) : apiKey;
        this.baseUrl = baseUrl == null || baseUrl.trim().isEmpty() ? ((baseUrlFromEnv = System.getenv("MINDEE_API_URL")) != null && !baseUrlFromEnv.trim().isEmpty() ? baseUrlFromEnv : DEFAULT_MINDEE_API_URL) : baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

