/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.geometry;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.mindee.geometry.Point;
import com.mindee.geometry.PolygonDeserializer;
import java.util.ArrayList;
import java.util.List;

@JsonDeserialize(using=PolygonDeserializer.class)
public class Polygon {
    private List<Point> coordinates = new ArrayList<Point>();

    public Polygon(List<Point> coordinates) {
        this.coordinates = coordinates;
    }

    public static PolygonBuilder builder() {
        return new PolygonBuilder();
    }

    public List<Point> getCoordinates() {
        return this.coordinates;
    }

    public static class PolygonBuilder {
        private List<Point> coordinates;

        PolygonBuilder() {
        }

        public PolygonBuilder coordinates(List<Point> coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Polygon build() {
            return new Polygon(this.coordinates);
        }

        public String toString() {
            return "Polygon.PolygonBuilder(coordinates=" + this.coordinates + ")";
        }
    }
}

