/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mindee.MindeeSettings;
import com.mindee.ParseParameter;
import com.mindee.parsing.CustomEndpoint;
import com.mindee.parsing.CustomEndpointInfo;
import com.mindee.parsing.EndpointInfo;
import com.mindee.parsing.MindeeApi;
import com.mindee.parsing.common.Document;
import com.mindee.parsing.common.Inference;
import com.mindee.parsing.common.PredictResponse;
import com.mindee.utils.MindeeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class MindeeHttpApi
implements MindeeApi {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final MindeeSettings mindeeSettings;
    private final HttpClientBuilder httpClientBuilder;
    private final Function<CustomEndpoint, String> urlFromEndpoint;

    public MindeeHttpApi(MindeeSettings mindeeSettings) {
        this(mindeeSettings, null, null);
    }

    private MindeeHttpApi(MindeeSettings mindeeSettings, HttpClientBuilder httpClientBuilder, Function<CustomEndpoint, String> urlFromEndpoint) {
        this.mindeeSettings = mindeeSettings;
        this.httpClientBuilder = httpClientBuilder != null ? httpClientBuilder : HttpClientBuilder.create().useSystemProperties();
        this.urlFromEndpoint = urlFromEndpoint != null ? urlFromEndpoint : this::buildUrl;
    }

    @Override
    public <DocT extends Inference> Document<DocT> predict(Class<DocT> documentClass, ParseParameter parseParameter) throws MindeeException, IOException {
        CustomEndpoint customEndpoint;
        EndpointInfo endpointAnnotation = documentClass.getAnnotation(EndpointInfo.class);
        if (endpointAnnotation == null) {
            CustomEndpointInfo customEndpointAnnotation = documentClass.getAnnotation(CustomEndpointInfo.class);
            if (customEndpointAnnotation == null) {
                throw new MindeeException("The class is not supported as a prediction model. The endpoint attribute is missing. Please refer to the document or contact the support.");
            }
            customEndpoint = new CustomEndpoint(customEndpointAnnotation.endpointName(), customEndpointAnnotation.accountName(), customEndpointAnnotation.version());
        } else {
            customEndpoint = new CustomEndpoint(endpointAnnotation.endpointName(), endpointAnnotation.accountName(), endpointAnnotation.version());
        }
        return this.predict(documentClass, customEndpoint, parseParameter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <DocT extends Inference> Document<DocT> predict(Class<DocT> documentClass, CustomEndpoint customEndpoint, ParseParameter parseParameter) throws MindeeException, IOException {
        mapper.findAndRegisterModules();
        HttpPost post = new HttpPost(this.urlFromEndpoint.apply(customEndpoint));
        HttpEntity entity = this.buildHttpBody(parseParameter);
        if (this.mindeeSettings.getApiKey().isPresent()) {
            post.setHeader("Authorization", this.mindeeSettings.getApiKey().get());
        }
        post.setHeader("User-Agent", this.getUserAgent());
        post.setEntity(entity);
        String errorMessage = "Mindee API client : ";
        try (CloseableHttpClient httpClient = this.httpClientBuilder.build();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            int length;
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity.getContentLength() != 0L) {
                JavaType type = mapper.getTypeFactory().constructParametricType(PredictResponse.class, new Class[]{documentClass});
                PredictResponse predictResponse = (PredictResponse)mapper.readValue(responseEntity.getContent(), type);
                if (this.is2xxStatusCode(response.getStatusLine().getStatusCode())) {
                    Document document = predictResponse.getDocument();
                    return document;
                }
                if (predictResponse == null) throw new MindeeException(errorMessage);
                errorMessage = errorMessage + predictResponse.getApiRequest().getError().toString();
                throw new MindeeException(errorMessage);
            }
            ByteArrayOutputStream contentRead = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = responseEntity.getContent().read(buffer)) != -1) {
                contentRead.write(buffer, 0, length);
            }
            errorMessage = errorMessage + " Unhandled - HTTP Status code " + response.getStatusLine().getStatusCode() + " - Content " + contentRead.toString("UTF-8");
            throw new MindeeException(errorMessage);
        }
        catch (IOException err) {
            throw new MindeeException(err.getMessage(), err);
        }
    }

    private boolean is2xxStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode <= 299;
    }

    private String getUserAgent() {
        String javaVersion = System.getProperty("java.version");
        String sdkVersion = this.getClass().getPackage().getImplementationVersion();
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            osName = "windows";
        } else if (osName.contains("darwin")) {
            osName = "macos";
        } else if (osName.contains("mac")) {
            osName = "macos";
        } else if (osName.contains("linux")) {
            osName = "linux";
        } else if (osName.contains("freebsd")) {
            osName = "freebsd";
        } else if (osName.contains("aix")) {
            osName = "aix";
        }
        return String.format("mindee-api-java@v%s java-v%s %s", sdkVersion, javaVersion, osName);
    }

    private String buildUrl(CustomEndpoint customEndpoint) {
        return this.mindeeSettings.getBaseUrl() + "/products/" + customEndpoint.getAccountName() + "/" + customEndpoint.getEndpointName() + "/v" + customEndpoint.getVersion() + "/predict";
    }

    private HttpEntity buildHttpBody(ParseParameter parseParameter) throws JsonProcessingException, UnsupportedEncodingException {
        if (parseParameter.getFile() != null) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("document", parseParameter.getFile(), ContentType.DEFAULT_BINARY, parseParameter.getFileName());
            if (Boolean.TRUE.equals(parseParameter.getIncludeWords())) {
                builder.addTextBody("include_mvision", "true");
            }
            return builder.build();
        }
        if (parseParameter.getFileUrl() != null) {
            HashMap<String, URL> urlMap = new HashMap<String, URL>();
            urlMap.put("document", parseParameter.getFileUrl());
            StringEntity entity = new StringEntity(mapper.writeValueAsString(urlMap), ContentType.APPLICATION_JSON);
            return entity;
        }
        throw new MindeeException("Either document bytes or a document url are needed");
    }

    public static MindeeHttpApiBuilder builder() {
        return new MindeeHttpApiBuilder();
    }

    public static class MindeeHttpApiBuilder {
        private MindeeSettings mindeeSettings;
        private HttpClientBuilder httpClientBuilder;
        private Function<CustomEndpoint, String> urlFromEndpoint;

        MindeeHttpApiBuilder() {
        }

        public MindeeHttpApiBuilder mindeeSettings(MindeeSettings mindeeSettings) {
            this.mindeeSettings = mindeeSettings;
            return this;
        }

        public MindeeHttpApiBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        public MindeeHttpApiBuilder urlFromEndpoint(Function<CustomEndpoint, String> urlFromEndpoint) {
            this.urlFromEndpoint = urlFromEndpoint;
            return this;
        }

        public MindeeHttpApi build() {
            return new MindeeHttpApi(this.mindeeSettings, this.httpClientBuilder, this.urlFromEndpoint);
        }

        public String toString() {
            return "MindeeHttpApi.MindeeHttpApiBuilder(mindeeSettings=" + this.mindeeSettings + ", httpClientBuilder=" + this.httpClientBuilder + ", urlFromEndpoint=" + this.urlFromEndpoint + ")";
        }
    }
}

