/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mindee.parsing.SummaryHelper;
import com.mindee.parsing.common.Page;
import com.mindee.parsing.common.Product;
import java.util.ArrayList;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Inference<T, U> {
    @JsonProperty(value="is_rotation_applied")
    private boolean isRotationApplied;
    @JsonProperty(value="product")
    private Product product;
    @JsonProperty(value="pages")
    private ArrayList<Page<T>> pages;
    @JsonProperty(value="prediction")
    private U documentPrediction;

    public String toString() {
        String summary = String.format("%nInference%n", new Object[0]) + String.format("#########%n", new Object[0]) + String.format(":Product: %s v%s%n", this.getProduct().getName(), this.getProduct().getVersion()) + String.format(":Rotation applied: %s%n", this.isRotationApplied() ? "Yes" : "No") + String.format("%n", new Object[0]) + String.format("Prediction%n", new Object[0]) + String.format("==========%n", new Object[0]) + this.documentPrediction.toString() + String.format("%nPage Predictions%n", new Object[0]) + String.format("================%n%n", new Object[0]) + this.pages.stream().map(Page::toString).collect(Collectors.joining(String.format("%n", new Object[0]))) + String.format("%n", new Object[0]);
        return SummaryHelper.cleanSummary(summary);
    }

    public boolean isRotationApplied() {
        return this.isRotationApplied;
    }

    public Product getProduct() {
        return this.product;
    }

    public ArrayList<Page<T>> getPages() {
        return this.pages;
    }

    public U getDocumentPrediction() {
        return this.documentPrediction;
    }
}

