/*
 * Decompiled with CFR 0.152.
 */
package com.mindee.parsing.common.field;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.mindee.geometry.BoundingBoxUtils;
import com.mindee.geometry.Polygon;
import com.mindee.geometry.PolygonDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class BaseField {
    @JsonIgnore
    private final Polygon boundingBox;
    @JsonProperty(value="confidence")
    private Double confidence;
    @JsonProperty(value="polygon")
    @JsonDeserialize(using=PolygonDeserializer.class)
    private Polygon polygon;
    @JsonProperty(value="page_id")
    private Integer id;

    protected BaseField(@JsonProperty(value="confidence") Double confidence, @JsonProperty(value="polygon") @JsonDeserialize(using=PolygonDeserializer.class) Polygon polygon, @JsonProperty(value="page_id") Integer id) {
        this.confidence = confidence;
        this.polygon = polygon;
        this.id = id;
        this.boundingBox = polygon != null ? BoundingBoxUtils.createBoundingBoxFrom(this.polygon) : null;
    }

    protected BaseField() {
        this.boundingBox = this.polygon != null ? BoundingBoxUtils.createBoundingBoxFrom(this.polygon) : null;
    }

    public Polygon getBoundingBox() {
        return this.boundingBox;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public Integer getId() {
        return this.id;
    }
}

